directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data

  const
    ProgLen = 49;
  end_const;

  var
    dbg : boolean {init_value = false};
    rx : real {init_value = 0};
    ry : real {init_value = 0};
    rz : real {init_value = 1};
    ra : real {init_value = 0};
    speed : real {init_value = 0.002};
    baseArray : array[ 0..ProgLen ] of real {init_value = 0};
    armArray : array[ 0..ProgLen ] of real {init_value = 0};
    forearmArray : array[ 0..ProgLen ] of real {init_value = 0};
    wristArray : array[ 0..ProgLen ] of real {init_value = 0};
    handArray : array[ 0..ProgLen ] of real {init_value = 0};
    handturntableArray : array[ 0..ProgLen ] of real {init_value = 0};
    thumbsArray : array[ 0..ProgLen ] of real {init_value = 0};
    objectrotationArray : array[ 0..ProgLen ] of real {init_value = 0};
    objecttranslationArray : array[ 0..ProgLen ] of real {init_value = 0};
    issparkleArray : array[ 0..ProgLen ] of boolean {init_value = false};
    sparklexArray : array[ 0..ProgLen ] of real {init_value = 0};
    sparkleyArray : array[ 0..ProgLen ] of real {init_value = 0};
    sparklezArray : array[ 0..ProgLen ] of real {init_value = 0};
    sparkledelayArray : array[ 0..ProgLen ] of real {init_value = 1};
    MaxStep : real {init_value = 0};
    ActualStep : real {init_value = 0};
    AltObject : boolean {init_value = false};
    weld : real {init_value = 0};
    WeldSound : boolean {init_value = false};
    ServoSound : boolean {init_value = false};
  end_var;

end_data;

instrument

  panel Back;
    gui
      owner = background;
      position = 15, 35, 1016, 741;
      window
        type = normal;
        title = 'Control Web - Realtime Rendered 3D Visualisation';
      end_window;
    end_gui;
  end_panel;

  gl_panel panel3d;
    gui
      owner = Back;
      position = 0, 0, 1016, 624;
    end_gui;
    material
      item
        name = 'background';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'back01.BMP';
      end_item;
      item
        name = 'sphere_map';
        ambient = 0.150, 0.150, 0.150, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 0.250, 0.250, 0.250, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'env.JPG';
      end_item;
    end_material;
    paint_texture_method = linear_texture;

    procedure OnActivate();
    begin
      self.Rotate( ra, rx, ry, rz );
    end_procedure;

  end_gl_panel;

  gl_graph weld_chart;
    const
      koef = 0.8;
    end_const;
    static
      Filtered : real;
      LastSignal : real;
    end_static;

    activity
      period = 0.02;
    end_activity;
    gui
      owner = panel3d;
      position = 720, 93, 259, 113;
    end_gui;
    expression = Filtered;
    history_x = 250;
    v_grid = 5;
    h_grid = 8;
    colors
      grid = 10, 10, 10;
    end_colors;

    procedure OnActivate();
    begin
      Filtered = LastSignal * koef + weld * ( 1 - koef );
      if Filtered < 0.00001 then
        (* underflow float point error prophylaxis *)
        Filtered = 0;
      end;
      LastSignal = Filtered;
    end_procedure;

  end_gl_graph;

  gl_model object;
    const
      base_x = 0;
      base_y = 0;
      base_z = 0;
    end_const;
    static
      base_elev : real {comment = 'Elevation, <-360,360>'};
      base_speed : real {init_value = 2; comment = 'Maximal base rotation speed'};
      base_acc : real;
      base_required : real;
      base_cyclic : boolean;
      xtranslation_elev : real;
      xtranslation_speed : real {init_value = 0.05; comment = 'Maximal translation speed'};
      xtranslation_acc : real;
      xtranslation_required : real;
      paused : boolean;
    end_static;

    gui
      owner = panel3d;
      position = 559, 268, 325, 323;
    end_gui;
    group
      item
        name = 'object';
        translate
          x = limit_interpolator {
            source = xtranslation_elev;
            lowmap = -1, -20;
            highmap = 1, 300;
          };
          y = 0;
          z = 0;
        end_translate;
        rotate
          x = 0;
          y = 1;
          z = 0;
          angle = base_elev % 360;
        end_rotate;
        rotate_center
          x = base_x;
          y = base_y;
          z = base_z;
        end_rotate_center;
      end_item;
    end_group;
    file = 'cabin01.obj';

    procedure OnActivate();
    begin
      if speed > 0 then
        paused = true;
        pause speed;
        paused = false;
      end;

      if xtranslation_required <> xtranslation_elev then
        if xtranslation_required < xtranslation_elev then
          xtranslation_acc = -1;
        elsif xtranslation_required > xtranslation_elev then
          xtranslation_acc = 1;
        end;
        xtranslation_elev = xtranslation_elev + xtranslation_speed * xtranslation_acc;
        if abs( xtranslation_elev - xtranslation_required ) < xtranslation_speed then
          xtranslation_elev = xtranslation_required;
        end;
        if xtranslation_elev > 1 then
          xtranslation_elev = 1;
        elsif xtranslation_elev < -1 then
          xtranslation_elev = -1;
        end;
        send self;
      else
        xtranslation_acc = 0;
      end;

      if base_cyclic then
        base_elev = base_elev + base_speed * base_acc;
        if base_elev > 360 then
          base_elev = base_elev - 360;
        elsif base_elev < 0 then
          base_elev = base_elev + 360;
        end;
        send self;
      elsif base_required <> base_elev then
        if base_elev < base_required then
          if base_required - base_elev < 180 then
            base_acc = 1;
          else
            base_acc = -1;
          end;
        else (* base_elev > base_required *)
          if base_elev - base_required < 180 then
            base_acc = -1;
          else
            base_acc = 1;
          end;
        end;
        base_elev = base_elev + base_speed * base_acc;
        if abs( base_elev - base_required ) < base_speed then
          base_elev = base_required;
        end;
        if base_elev > 360 then
          base_elev = base_elev - 360;
        elsif base_elev < 0 then
          base_elev = base_elev + 360;
        end;
        send self;
      else
        base_acc = 0;
      end;

      mCabinRotation.SetValue( base_elev );
      mCabinTranslation.SetValue( xtranslation_elev );
    end_procedure;

    procedure SetTranslationPos( Pos : real );
    begin
      if Pos < -1 then
        Pos = -1;
      elsif Pos > 1 then
        Pos = 1;
      end;
      if xtranslation_elev <> Pos then
        xtranslation_required = Pos;
        send self;
      end;
    end_procedure;

    procedure StopTranslation();
    begin
      xtranslation_required = xtranslation_elev;
      send self;
    end_procedure;

    procedure SetBasePos( Pos : real );
    begin
      if Pos < 0 then
        Pos = 0;
      elsif Pos > 360 then
        Pos = 360;
      end;
      if base_elev <> Pos then
        base_required = Pos;
        send self;
      end;
    end_procedure;

    procedure BaseLeft();
    begin
      base_acc = -1;
      base_cyclic = true;
      send self;
    end_procedure;

    procedure BaseRight();
    begin
      base_acc = 1;
      base_cyclic = true;
      send self;
    end_procedure;

    procedure BaseStop();
    begin
      base_acc = 0;
      base_cyclic = false;
      base_required = base_elev;
      send self;
    end_procedure;

    procedure IsReady(): boolean;
    begin
      return ( base_acc = 0 ) and
             ( xtranslation_acc = 0 ) and
             not paused;
    end_procedure;

  end_gl_model;

  gl_sparkle sparkle;
    gui
      owner = panel3d;
      position = 238, 48, 508, 503;
    end_gui;
    group
      item
        name = 'sparkle';
        translate
          x = sparklexArray[ActualStep - 1];
          y = sparkleyArray[ActualStep - 1];
          z = sparklezArray[ActualStep - 1];
        end_translate;
      end_item;
    end_group;
    expression = issparkleArray[ActualStep - 1];
    particles = 250;
    look = look_2;
  end_gl_sparkle;

  gl_model robot;
    const
      base_x = -1;
      base_y = 0;
      base_z = -66;
      arm_x = base_x;
      arm_y = -20;
      arm_z = base_z;
      forearm_x = base_x;
      forearm_y = 68;
      forearm_z = base_z + 38;
      wrist_x = base_x;
      wrist_y = 30;
      wrist_z = 62;
      hand_x = base_x;
      hand_y = 25;
      hand_z = 80;
      handturntable_x = -12;
      handturntable_y = 11;
      handturntable_z = 80;
      thumbs_ax = 0;
      thumbs_ay = 1;
      thumbs_az = 1;
      thumbs_x = -12;
      thumbs_y = 10;
      thumbs_z = 80;
      accincr = 0.1;
    end_const;
    static
      base_elev : real {comment = 'Elevation, <-360,360>'};
      base_speed : real {init_value = 2; comment = 'Maximal base rotation speed'};
      base_acc : real;
      base_required : real;
      base_cyclic : boolean;
      arm_elev : real {comment = 'Elevation <-1,1>'};
      arm_speed : real {init_value = 0.02; comment = 'Maximal elevation speed'};
      arm_required : real;
      arm_acc : real;
      forearm_elev : real {comment = 'Elevation'};
      forearm_speed : real {init_value = 0.02; comment = 'Maximal elevation speed'};
      forearm_required : real;
      forearm_acc : real;
      wrist_elev : real;
      wrist_speed : real {init_value = 0.03};
      wrist_required : real;
      wrist_acc : real;
      hand_elev : real;
      hand_speed : real {init_value = 0.03};
      hand_required : real;
      hand_acc : real;
      handturntable_elev : real;
      handturntable_speed : real {init_value = 2};
      handturntable_required : real;
      handturntable_cyclic : boolean {init_value = true};
      handturntable_acc : real;
      thumbs_elev : real;
      thumbs_speed : real {init_value = 0.05};
      thumbs_required : real;
      thumbs_acc : real;
      paused : boolean;
    end_static;

    gui
      owner = panel3d;
      position = 81, 189, 427, 423;
    end_gui;
    group
      item
        name = 'RightThumb';
        rotate
          x = thumbs_ax;
          y = thumbs_ay;
          z = thumbs_az;
          angle = limit_interpolator {
            source = thumbs_elev;
            lowmap = -1, 18;
            highmap = 1, -3;
          };
        end_rotate;
        rotate_center
          x = thumbs_x;
          y = thumbs_y;
          z = thumbs_z;
        end_rotate_center;
      end_item;
      item
        name = 'Base1';
        rotate
          x = 0;
          y = 1;
          z = 0;
          angle = base_elev % 360;
        end_rotate;
        rotate_center
          x = base_x;
          y = base_y;
          z = base_z;
        end_rotate_center;
      end_item;
      item
        name = 'Forearm';
        rotate
          x = 1;
          y = 0;
          z = 0;
          angle = limit_interpolator {
            source = forearm_elev;
            lowmap = -1, -90;
            highmap = 1, 60;
          };
        end_rotate;
        rotate_center
          x = forearm_x;
          y = forearm_y;
          z = forearm_z;
        end_rotate_center;
      end_item;
      item
        name = 'Arm1';
        rotate
          x = 1;
          y = 0;
          z = 0;
          angle = limit_interpolator {
            source = arm_elev;
            lowmap = -1, -70;
            highmap = 1, 70;
          };
        end_rotate;
        rotate_center
          x = arm_x;
          y = arm_y;
          z = arm_z;
        end_rotate_center;
      end_item;
      item
        name = 'Wrist1';
        rotate
          x = 1;
          y = 0;
          z = 0;
          angle = limit_interpolator {
            source = wrist_elev;
            lowmap = -1, -115;
            highmap = 1, 65;
          };
        end_rotate;
        rotate_center
          x = wrist_x;
          y = wrist_y;
          z = wrist_z;
        end_rotate_center;
      end_item;
      item
        name = 'HandTurntable';
        rotate
          x = -1.43;
          y = -1;
          z = 1;
          angle = handturntable_elev % 360;
        end_rotate;
        rotate_center
          x = handturntable_x;
          y = handturntable_y;
          z = handturntable_z;
        end_rotate_center;
      end_item;
      item
        name = 'Hand';
        rotate
          x = 0;
          y = 1;
          z = 1;
          angle = limit_interpolator {
            source = hand_elev;
            lowmap = -1, -45;
            highmap = 1, 135;
          };
        end_rotate;
        rotate_center
          x = hand_x;
          y = hand_y;
          z = hand_z;
        end_rotate_center;
      end_item;
      item
        name = 'LeftThumb';
        rotate
          x = thumbs_ax;
          y = thumbs_ay;
          z = thumbs_az;
          angle = limit_interpolator {
            source = thumbs_elev;
            lowmap = -1, -18;
            highmap = 1, 3;
          };
        end_rotate;
        rotate_center
          x = thumbs_x;
          y = thumbs_y;
          z = thumbs_z;
        end_rotate_center;
      end_item;
    end_group;
    file = 'robotarm01.obj';

    procedure OnActivate();
    begin
      if speed > 0 then
        paused = true;
        pause speed;
        paused = false;
      end;

      if arm_required <> arm_elev then
        if arm_required < arm_elev then
          arm_acc = -1;
        elsif arm_required > arm_elev then
          arm_acc = 1;
        end;
        arm_elev = arm_elev + arm_speed * arm_acc;
        if abs( arm_elev - arm_required ) < arm_speed then
          arm_elev = arm_required;
        end;
        if arm_elev > 1 then
          arm_elev = 1;
        elsif arm_elev < -1 then
          arm_elev = -1;
        end;
        send self;
      else
        arm_acc = 0;
      end;

      if forearm_required <> forearm_elev then
        if forearm_required < forearm_elev then
          forearm_acc = -1;
        elsif forearm_required > forearm_elev then
          forearm_acc = 1;
        end;
        forearm_elev = forearm_elev + forearm_speed * forearm_acc;
        if abs( forearm_elev - forearm_required ) < forearm_speed then
          forearm_elev = forearm_required;
        end;
        if forearm_elev > 1 then
          forearm_elev = 1;
        elsif forearm_elev < -1 then
          forearm_elev = -1;
        end;
        send self;
      else
        forearm_acc = 0;
      end;

      if wrist_required <> wrist_elev then
        if wrist_required < wrist_elev then
          wrist_acc = -1;
        elsif wrist_required > wrist_elev then
          wrist_acc = 1;
        end;
        wrist_elev = wrist_elev + wrist_speed * wrist_acc;
        if abs( wrist_elev - wrist_required ) < wrist_speed then
          wrist_elev = wrist_required;
        end;
        if wrist_elev > 1 then
          wrist_elev = 1;
        elsif wrist_elev < -1 then
          wrist_elev = -1;
        end;
        send self;
      else
        wrist_acc = 0;
      end;

      if thumbs_required <> thumbs_elev then
        if thumbs_required < thumbs_elev then
          thumbs_acc = -1;
        elsif thumbs_required > thumbs_elev then
          thumbs_acc = 1;
        end;
        thumbs_elev = thumbs_elev + thumbs_speed * thumbs_acc;
        if abs( thumbs_elev - thumbs_required ) < thumbs_speed then
          thumbs_elev = thumbs_required;
        end;
        if thumbs_elev > 1 then
          thumbs_elev = 1;
        elsif thumbs_elev < -1 then
          thumbs_elev = -1;
        end;
        send self;
      else
        thumbs_acc = 0;
      end;

      if hand_required <> hand_elev then
        if hand_required < hand_elev then
          hand_acc = -1;
        elsif hand_required > hand_elev then
          hand_acc = 1;
        end;
        hand_elev = hand_elev + hand_speed * hand_acc;
        if abs( hand_elev - hand_required ) < hand_speed then
          hand_elev = hand_required;
        end;
        if hand_elev > 1 then
          hand_elev = 1;
        elsif hand_elev < -1 then
          hand_elev = -1;
        end;
        send self;
      else
        hand_acc = 0;
      end;

      if handturntable_cyclic then
        handturntable_elev = handturntable_elev + handturntable_speed * handturntable_acc;
        if handturntable_elev > 360 then
          handturntable_elev = handturntable_elev - 360;
        elsif handturntable_elev < 0 then
          handturntable_elev = handturntable_elev + 360;
        end;
        send self;
      elsif handturntable_required <> handturntable_elev then
        if handturntable_elev < handturntable_required then
          if handturntable_required - handturntable_elev < 180 then
            handturntable_acc = 1;
          else
            handturntable_acc = -1;
          end;
        else (* handturntable_elev > handturntable_required *)
          if handturntable_elev - handturntable_required < 180 then
            handturntable_acc = -1;
          else
            handturntable_acc = 1;
          end;
        end;
        handturntable_elev = handturntable_elev + handturntable_speed * handturntable_acc;
        if abs( handturntable_elev - handturntable_required ) < handturntable_speed then
          handturntable_elev = handturntable_required;
        end;
        if handturntable_elev > 360 then
          handturntable_elev = handturntable_elev - 360;
        elsif handturntable_elev < 0 then
          handturntable_elev = handturntable_elev + 360;
        end;
        send self;
      else
        handturntable_acc = 0;
      end;

      if base_cyclic then
        base_elev = base_elev + base_speed * base_acc;
        if base_elev > 360 then
          base_elev = base_elev - 360;
        elsif base_elev < 0 then
          base_elev = base_elev + 360;
        end;
        send self;
      elsif base_required <> base_elev then
        if base_elev < base_required then
          if base_required - base_elev < 180 then
            base_acc = 1;
          else
            base_acc = -1;
          end;
        else (* base_elev > base_required *)
          if base_elev - base_required < 180 then
            base_acc = -1;
          else
            base_acc = 1;
          end;
        end;
        base_elev = base_elev + base_speed * base_acc;
        if abs( base_elev - base_required ) < base_speed then
          base_elev = base_required;
        end;
        if base_elev > 360 then
          base_elev = base_elev - 360;
        elsif base_elev < 0 then
          base_elev = base_elev + 360;
        end;
        send self;
      else
        base_acc = 0;
      end;

      mBase.SetValue( base_elev );
      mArm.SetValue( arm_elev );
      mForearm.SetValue( forearm_elev );
      mWrist.SetValue( wrist_elev );
      mHandSwing.SetValue( hand_elev );
      mHandRotation.SetValue( handturntable_elev );
      mThumbs.SetValue( thumbs_elev );
    end_procedure;

    procedure SetArmPos( Pos : real );
    begin
      if Pos < -1 then
        Pos = -1;
      elsif Pos > 1 then
        Pos = 1;
      end;
      if arm_elev <> Pos then
        arm_required = Pos;
        send self;
      end;
    end_procedure;

    procedure StopArm();
    begin
      arm_required = arm_elev;
      send self;
    end_procedure;

    procedure SetForearmPos( Pos : real );
    begin
      if Pos < -1 then
        Pos = -1;
      elsif Pos > 1 then
        Pos = 1;
      end;
      if forearm_elev <> Pos then
        forearm_required = Pos;
        send self;
      end;
    end_procedure;

    procedure StopForearm();
    begin
      forearm_required = forearm_elev;
      send self;
    end_procedure;

    procedure SetWristPos( Pos : real );
    begin
      if Pos < -1 then
        Pos = -1;
      elsif Pos > 1 then
        Pos = 1;
      end;
      if wrist_elev <> Pos then
        wrist_required = Pos;
        send self;
      end;
    end_procedure;

    procedure StopWrist();
    begin
      wrist_required = wrist_elev;
      send self;
    end_procedure;

    procedure SetHandPos( Pos : real );
    begin
      if Pos < -1 then
        Pos = -1;
      elsif Pos > 1 then
        Pos = 1;
      end;
      if hand_elev <> Pos then
        hand_required = Pos;
        send self;
      end;
    end_procedure;

    procedure StopHand();
    begin
      hand_required = hand_elev;
      send self;
    end_procedure;

    procedure SetThumbsPos( Pos : real );
    begin
      if Pos < -1 then
        Pos = -1;
      elsif Pos > 1 then
        Pos = 1;
      end;
      if thumbs_elev <> Pos then
        thumbs_required = Pos;
        send self;
      end;
    end_procedure;

    procedure StopThumbs();
    begin
      thumbs_required = thumbs_elev;
      send self;
    end_procedure;

    procedure SetHandturntablePos( Pos : real );
    begin
      if Pos < 0 then
        Pos = 0;
      elsif Pos > 360 then
        Pos = 360;
      end;
      if handturntable_elev <> Pos then
        handturntable_required = Pos;
        handturntable_cyclic = false;
        send self;
      end;
    end_procedure;

    procedure HandTurntableLeft();
    begin
      handturntable_acc = -1;
      handturntable_cyclic = true;
      send self;
    end_procedure;

    procedure HandTurntableRight();
    begin
      handturntable_acc = 1;
      handturntable_cyclic = true;
      send self;
    end_procedure;

    procedure HandTurntableStop();
    begin
      handturntable_acc = 0;
      handturntable_cyclic = false;
      handturntable_required = handturntable_elev;
      send self;
    end_procedure;

    procedure SetBasePos( Pos : real );
    begin
      if Pos < 0 then
        Pos = 0;
      elsif Pos > 360 then
        Pos = 360;
      end;
      if base_elev <> Pos then
        base_required = Pos;
        base_cyclic = false;
        send self;
      end;
    end_procedure;

    procedure BaseLeft();
    begin
      base_acc = -1;
      base_cyclic = true;
      send self;
    end_procedure;

    procedure BaseRight();
    begin
      base_acc = 1;
      base_cyclic = true;
      send self;
    end_procedure;

    procedure BaseStop();
    begin
      base_acc = 0;
      base_cyclic = false;
      base_required = base_elev;
      send self;
    end_procedure;

    procedure IsReady(): boolean;
    begin
      return ( base_acc = 0 ) and
             ( arm_acc = 0 ) and
             ( forearm_acc = 0 ) and
             ( wrist_acc = 0 ) and
             ( hand_acc = 0 ) and
             ( handturntable_acc = 0 ) and
             ( thumbs_acc = 0 ) and
             not paused;
    end_procedure;

  end_gl_model;

  panel control_panel;
    gui
      owner = Back;
      position = 0, 624, 1016, 117;
    end_gui;
    background
      file = 'CPANE.BMP';
    end_background;
  end_panel;

  switch swWeldSound;
    gui
      owner = control_panel;
      position = 513, 92, 24, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    output = WeldSound;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'nw';
    false_text = 'ws';
  end_switch;

  switch swServoSound;
    gui
      owner = control_panel;
      position = 483, 92, 23, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    output = ServoSound;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'ns';
    false_text = 'ss';
  end_switch;

  label label_2;
    gui
      owner = control_panel;
      position = 806, 4;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'sparkle control';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 738, 64;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'program';
      font = 'Arial', 8, normal;
      text = 'selector';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 674, 4;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'steps';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 718, 4;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'program storage';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 916, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      text = 'position of camera';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  switch swInsertStep;
    gui
      owner = control_panel;
      position = 660, 63, 61, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'insert step';
    false_text = 'insert step';
    logic = set_true;

    procedure OnOutput( Output : boolean );
    var
      i : real;
      index : real;
    begin
      if ( ActualStep - 1 ) < ProgLen then

        index = ProgLen;
        for i = ( ActualStep - 1 ) to ( ProgLen - 1 ) do

          baseArray[ index ] = baseArray[ index - 1 ];
          armArray[ index ] = armArray[ index - 1 ];
          forearmArray[ index ] = forearmArray[ index - 1 ];
          wristArray[ index ] = wristArray[ index - 1 ];
          handArray[ index ] = handArray[ index - 1 ];
          handturntableArray[ index ] = handturntableArray[ index - 1 ];
          thumbsArray[ index ] = thumbsArray[ index - 1 ];
    
          objectrotationArray[ index ] = objectrotationArray[ index - 1 ];
          objecttranslationArray[ index ] = objecttranslationArray[ index - 1 ];
    
          issparkleArray[ index ] = issparkleArray[ index - 1 ];
          sparklexArray[ index ] = sparklexArray[ index - 1 ];
          sparkleyArray[ index ] = sparkleyArray[ index - 1 ];
          sparklezArray[ index ] = sparklezArray[ index - 1 ];
          sparkledelayArray[ index ] = sparkledelayArray[ index - 1 ];

          index = index + 1;
        end;

      end;
    end_procedure;

  end_switch;

  switch swBaseSurface;
    gui
      owner = control_panel;
      position = 12, 92, 30, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'wire';
    false_text = 'solid';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.RenderWireFrame( 'Base1', true );
        robot.RenderSmoothSurface( 'Base1', false );
        robot.RenderWireFrame( 'Base2', true );
        robot.RenderSmoothSurface( 'Base2', false );
        robot.RenderWireFrame( 'Base3', true );
        robot.RenderSmoothSurface( 'Base3', false );
      else
        robot.RenderWireFrame( 'Base1', false );
        robot.RenderSmoothSurface( 'Base1', true );
        robot.RenderWireFrame( 'Base2', false );
        robot.RenderSmoothSurface( 'Base2', true );
        robot.RenderWireFrame( 'Base3', false );
        robot.RenderSmoothSurface( 'Base3', true );
      end;
    end_procedure;

  end_switch;

  switch swCopyStep;
    gui
      owner = control_panel;
      position = 660, 41, 61, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'copy step';
    false_text = 'copy step';
    logic = set_true;

    procedure OnOutput( Output : boolean );
    var
      i : real;
      index : real;
    begin
      if ( ActualStep - 1 ) < ProgLen then
        i = ActualStep - 1;

        baseArray[ i + 1 ] = baseArray[ i ];
        armArray[ i + 1 ] = armArray[ i ];
        forearmArray[ i + 1 ] = forearmArray[ i ];
        wristArray[ i + 1 ] = wristArray[ i ];
        handArray[ i + 1 ] = handArray[ i ];
        handturntableArray[ i + 1 ] = handturntableArray[ i ];
        thumbsArray[ i + 1 ] = thumbsArray[ i ];
  
        objectrotationArray[ i + 1 ] = objectrotationArray[ i ];
        objecttranslationArray[ i + 1 ] = objecttranslationArray[ i ];
  
        issparkleArray[ i + 1 ] = issparkleArray[ i ];
        sparklexArray[ i + 1 ] = sparklexArray[ i ];
        sparkleyArray[ i + 1 ] = sparkleyArray[ i ];
        sparklezArray[ i + 1 ] = sparklezArray[ i ];
        sparkledelayArray[ i + 1 ] = sparkledelayArray[ i ];

      end;
    end_procedure;

  end_switch;

  switch swDeleteStep;
    gui
      owner = control_panel;
      position = 660, 85, 61, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'delete step';
    false_text = 'delete step';
    logic = set_true;

    procedure OnOutput( Output : boolean );
    var
      i : real;
    begin
      if ( ActualStep - 1 ) < ProgLen then

        for i = ( ActualStep - 1 ) to ( ProgLen - 1 ) do

          baseArray[ i ] = baseArray[ i + 1 ];
          armArray[ i ] = armArray[ i + 1 ];
          forearmArray[ i ] = forearmArray[ i + 1 ];
          wristArray[ i ] = wristArray[ i + 1 ];
          handArray[ i ] = handArray[ i + 1 ];
          handturntableArray[ i ] = handturntableArray[ i + 1 ];
          thumbsArray[ i ] = thumbsArray[ i + 1 ];
    
          objectrotationArray[ i ] = objectrotationArray[ i + 1 ];
          objecttranslationArray[ i ] = objecttranslationArray[ i + 1 ];
    
          issparkleArray[ i ] = issparkleArray[ i + 1 ];
          sparklexArray[ i ] = sparklexArray[ i + 1 ];
          sparkleyArray[ i ] = sparkleyArray[ i + 1 ];
          sparklezArray[ i ] = sparklezArray[ i + 1 ];
          sparkledelayArray[ i ] = sparkledelayArray[ i + 1 ];

        end;

      end;
    end_procedure;

  end_switch;

  control cntSparkleDelay;
    gui
      owner = control_panel;
      position = 810, 96, 63, 18;
    end_gui;
    mode = count_box;
    range_to = 10;
    init_value = 1;
    real_step = 0.1;
    dec_places = 1;
  end_control;

  switch swObjectKind;
    gui
      owner = control_panel;
      position = 742, 92, 34, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    output = AltObject;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'cabin';
    false_text = 'car';

    procedure OnOutput( Output : boolean );
    begin

      if Output then
        object.LoadModel('futura.obj');
        object.Scale( 1.5, 1.5, 1.5 );
        object.Translate( 0, -42, 0 );
        AltObject = true;
      else
        object.LoadModel('cabin01.obj');
        object.Scale( 1, 1, 1 );
        object.Translate( 0, 0, 0 );
        AltObject = false;
      end;

      program_storage.LoadProgram();
    end_procedure;

  end_switch;

  switch swIsSparkle;
    gui
      owner = control_panel;
      position = 817, 20, 43, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'sparkle';
    false_text = 'quiet';

    procedure OnOutput( Output : boolean );
    begin
      sparkle.SetValue( Output );
      sparkle.Translate( cntSparkleX.GetValue(), cntSparkleY.GetValue(), cntSparkleZ.GetValue() );
      if Output then
        weld = 100;
      else
        weld = 0;
      end;
    end_procedure;

  end_switch;

  control cntSparkleZ;
    gui
      owner = control_panel;
      position = 810, 78, 63, 18;
    end_gui;
    mode = count_box;
    range_from = -1000;
    range_to = 1000;
    dec_places = 0;

    procedure OnOutput( Output : real );
    begin
      sparkle.Translate( cntSparkleX.GetValue(), cntSparkleY.GetValue(), Output );
    end_procedure;

  end_control;

  control cntSparkleY;
    gui
      owner = control_panel;
      position = 810, 60, 63, 18;
    end_gui;
    mode = count_box;
    range_from = -1000;
    range_to = 1000;
    dec_places = 0;

    procedure OnOutput( Output : real );
    begin
      sparkle.Translate( cntSparkleX.GetValue(), Output, cntSparkleZ.GetValue() );
    end_procedure;

  end_control;

  control cntSparkleX;
    gui
      owner = control_panel;
      position = 810, 42, 63, 18;
    end_gui;
    mode = count_box;
    range_from = -1000;
    range_to = 1000;
    dec_places = 0;

    procedure OnOutput( Output : real );
    begin
      sparkle.Translate( Output, cntSparkleY.GetValue(), cntSparkleZ.GetValue() );
    end_procedure;

  end_control;

  label label_2;
    gui
      owner = control_panel;
      position = 548, 97;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'max step';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  control cntMaxStep;
    gui
      owner = control_panel;
      position = 596, 94, 48, 19;
    end_gui;
    output = MaxStep;
    mode = count_box;
    range_from = 1;
    range_to = 50;
    init_value = 10;
    dec_places = 0;
  end_control;

  switch swLoadProgram;
    gui
      owner = control_panel;
      position = 722, 41, 75, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'load program';
    false_text = 'load program';
    logic = set_true;

    procedure OnOutput( Output : boolean );
    begin
      program_storage.LoadProgram();
    end_procedure;

  end_switch;

  switch swSaveProgram;
    gui
      owner = control_panel;
      position = 722, 19, 75, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'save program';
    false_text = 'save program';
    logic = set_true;

    procedure OnOutput( Output : boolean );
    begin
      program_storage.SaveProgram();
    end_procedure;

  end_switch;

  switch swSaveStep;
    gui
      owner = control_panel;
      position = 660, 19, 61, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'save step';
    false_text = 'save step';
    logic = set_true;

    procedure OnOutput( Output : boolean );
    begin
      baseArray[ ActualStep - 1 ] = mBase.GetValue();
      armArray[ ActualStep - 1 ] = mArm.GetValue();
      forearmArray[ ActualStep - 1 ] = mForearm.GetValue();
      wristArray[ ActualStep - 1 ] = mWrist.GetValue();
      handArray[ ActualStep - 1 ] = mHandSwing.GetValue();
      handturntableArray[ ActualStep - 1 ] = mHandRotation.GetValue();
      thumbsArray[ ActualStep - 1 ] = mThumbs.GetValue();

      objectrotationArray[ ActualStep - 1 ] = mCabinRotation.GetValue();
      objecttranslationArray[ ActualStep - 1 ] = mCabinTranslation.GetValue();

      issparkleArray[ ActualStep - 1 ] = swIsSparkle.GetValue();
      sparklexArray[ ActualStep - 1 ] = cntSparkleX.GetValue();
      sparkleyArray[ ActualStep - 1 ] = cntSparkleY.GetValue();
      sparklezArray[ ActualStep - 1 ] = cntSparkleZ.GetValue();
      sparkledelayArray[ ActualStep - 1 ] = cntSparkleDelay.GetValue();
    end_procedure;

  end_switch;

  switch swStepDown;
    gui
      owner = control_panel;
      position = 582, 65, 26, 26;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'STEPFW.ICO';
    false_icon = 'STEPFW.ICO';
    logic = set_true;

    procedure OnOutput( Output : boolean );
    begin
      pgController.StepUp();
    end_procedure;

  end_switch;

  switch swStepUp;
    gui
      owner = control_panel;
      position = 556, 65, 26, 26;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'STEPBW.ICO';
    false_icon = 'STEPBW.ICO';
    logic = set_true;

    procedure OnOutput( Output : boolean );
    begin
      pgController.StepDown();
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control_panel;
      position = 881, 66;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'z axis';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 881, 50;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'y axis';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 881, 34;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'x axis';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 884, 18;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'angle';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 548, 44;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'program step';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  switch swCabinTranslation_Right;
    gui
      owner = control_panel;
      position = 491, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'LARROW.ICO';
    false_icon = 'LARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        object.SetTranslationPos( -1 );
      else
        object.StopTranslation();
      end;
    end_procedure;

  end_switch;

  switch swobjectTranslation_Right;
    gui
      owner = control_panel;
      position = 491, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'RARROW.ICO';
    false_icon = 'RARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        object.SetTranslationPos( 1 );
      else
        object.StopTranslation();
      end;
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control_panel;
      position = 547, 24;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'translation';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 561, 9;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'rotation';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  meter mCabinRotation;
    gui
      owner = control_panel;
      position = 607, 8, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  meter mCabinTranslation;
    gui
      owner = control_panel;
      position = 607, 23, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  label label_2;
    gui
      owner = control_panel;
      position = 488, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'object';
      font = 'Arial', 8, normal;
      text = 'translation';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  switch cswitch_3;
    gui
      owner = control_panel;
      position = 445, 92, 30, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'wire';
    false_text = 'solid';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.RenderWireFrame( 'Base1', true );
        robot.RenderSmoothSurface( 'Base1', false );
        robot.RenderWireFrame( 'Base2', true );
        robot.RenderSmoothSurface( 'Base2', false );
        robot.RenderWireFrame( 'Base3', true );
        robot.RenderSmoothSurface( 'Base3', false );
      else
        robot.RenderWireFrame( 'Base1', false );
        robot.RenderSmoothSurface( 'Base1', true );
        robot.RenderWireFrame( 'Base2', false );
        robot.RenderSmoothSurface( 'Base2', true );
        robot.RenderWireFrame( 'Base3', false );
        robot.RenderSmoothSurface( 'Base3', true );
      end;
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control_panel;
      position = 448, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'object';
      font = 'Arial', 8, normal;
      text = 'rotation';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  switch swCabinRotate_Left;
    gui
      owner = control_panel;
      position = 445, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'LARROW.ICO';
    false_icon = 'LARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        object.BaseLeft();
      else
        object.BaseStop();
      end;
    end_procedure;

  end_switch;

  switch swCabinRotate_Right;
    gui
      owner = control_panel;
      position = 445, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'RARROW.ICO';
    false_icon = 'RARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        object.BaseRight();
      else
        object.BaseStop();
      end;
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control_panel;
      position = 914, 83;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'max';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 990, 83;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'min';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 880, 97;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'speed';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 329, 83;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'hand rotation';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 358, 97;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'thumbs';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 336, 69;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'hand swing';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 367, 54;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'wrist';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 354, 38;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'forearm';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 373, 24;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'arm';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 367, 9;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'base';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  switch swHandTurntableSurface;
    gui
      owner = control_panel;
      position = 241, 92, 30, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'wire';
    false_text = 'solid';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.RenderWireFrame( 'HandTurntable', true );
        robot.RenderSmoothSurface( 'HandTurntable', false );
      else
        robot.RenderWireFrame( 'HandTurntable', false );
        robot.RenderSmoothSurface( 'HandTurntable', true );
      end;
    end_procedure;

  end_switch;

  switch swHandSurface;
    gui
      owner = control_panel;
      position = 195, 92, 30, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'wire';
    false_text = 'solid';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.RenderWireFrame( 'Hand', true );
        robot.RenderSmoothSurface( 'Hand', false );
      else
        robot.RenderWireFrame( 'Hand', false );
        robot.RenderSmoothSurface( 'Hand', true );
      end;
    end_procedure;

  end_switch;

  switch swWristSurface;
    gui
      owner = control_panel;
      position = 150, 92, 30, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'wire';
    false_text = 'solid';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.RenderWireFrame( 'Wrist1', true );
        robot.RenderSmoothSurface( 'Wrist1', false );
        robot.RenderWireFrame( 'Wrist2', true );
        robot.RenderSmoothSurface( 'Wrist2', false );
      else
        robot.RenderWireFrame( 'Wrist1', false );
        robot.RenderSmoothSurface( 'Wrist1', true );
        robot.RenderWireFrame( 'Wrist2', false );
        robot.RenderSmoothSurface( 'Wrist2', true );
      end;
    end_procedure;

  end_switch;

  switch swForearmSurface;
    gui
      owner = control_panel;
      position = 104, 92, 30, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'wire';
    false_text = 'solid';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.RenderWireFrame( 'Forearm', true );
        robot.RenderSmoothSurface( 'Forearm', false );
      else
        robot.RenderWireFrame( 'Forearm', false );
        robot.RenderSmoothSurface( 'Forearm', true );
      end;
    end_procedure;

  end_switch;

  switch swArmSurface;
    gui
      owner = control_panel;
      position = 58, 92, 30, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'wire';
    false_text = 'solid';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.RenderWireFrame( 'Arm1', true );
        robot.RenderSmoothSurface( 'Arm1', false );
        robot.RenderWireFrame( 'Arm2', true );
        robot.RenderSmoothSurface( 'Arm2', false );
        robot.RenderWireFrame( 'Arm3', true );
        robot.RenderSmoothSurface( 'Arm3', false );
        robot.RenderWireFrame( 'Arm4', true );
        robot.RenderSmoothSurface( 'Arm4', false );
      else
        robot.RenderWireFrame( 'Arm1', false );
        robot.RenderSmoothSurface( 'Arm1', true );
        robot.RenderWireFrame( 'Arm2', false );
        robot.RenderSmoothSurface( 'Arm2', true );
        robot.RenderWireFrame( 'Arm3', false );
        robot.RenderSmoothSurface( 'Arm3', true );
        robot.RenderWireFrame( 'Arm4', false );
        robot.RenderSmoothSurface( 'Arm4', true );
      end;
    end_procedure;

  end_switch;

  switch swThumbsSurface;
    gui
      owner = control_panel;
      position = 288, 92, 30, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    font = 'Arial', 8, normal;
    true_text = 'wire';
    false_text = 'solid';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.RenderWireFrame( 'LeftThumb', true );
        robot.RenderSmoothSurface( 'LeftThumb', false );
        robot.RenderWireFrame( 'RightThumb', true );
        robot.RenderSmoothSurface( 'RightThumb', false );
      else
        robot.RenderWireFrame( 'LeftThumb', false );
        robot.RenderSmoothSurface( 'LeftThumb', true );
        robot.RenderWireFrame( 'RightThumb', false );
        robot.RenderSmoothSurface( 'RightThumb', true );
      end;
    end_procedure;

  end_switch;

  control speed_control;
    gui
      owner = control_panel;
      position = 913, 97, 95, 15;
    end_gui;
    output = speed;
    mode = horizontal_slider;
    range_to = 0.01;
    init_value = 0.002;
    real_step = 0.0005;
    dec_places = 15;
  end_control;

  label label_2;
    gui
      owner = control_panel;
      position = 284, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'thumbs';
      font = 'Arial', 8, normal;
      text = 'grip';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 238, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'hand';
      font = 'Arial', 8, normal;
      text = 'rotation';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 194, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'hand';
      font = 'Arial', 8, normal;
      text = 'swing';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 152, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'wrist';
      font = 'Arial', 8, normal;
      text = 'lift';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 99, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'forearm';
      font = 'Arial', 8, normal;
      text = 'lift';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 63, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'arm';
      font = 'Arial', 8, normal;
      text = 'lift';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  label label_2;
    gui
      owner = control_panel;
      position = 8, 2;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    justify = center;
    text_list
      font = 'Arial', 8, normal;
      text = 'base';
      font = 'Arial', 8, normal;
      text = 'rotation';
    end_text_list;
    colors
      ink = white;
    end_colors;
  end_label;

  meter mHandRotation;
    gui
      owner = control_panel;
      position = 398, 83, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  switch swThumbs_Open;
    gui
      owner = control_panel;
      position = 280, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'UARROW.ICO';
    false_icon = 'UARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetThumbsPos( -1 );
      else
        robot.StopThumbs();
      end;
    end_procedure;

  end_switch;

  switch swThumbs_Close;
    gui
      owner = control_panel;
      position = 280, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'DARROW.ICO';
    false_icon = 'DARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetThumbsPos( 1 );
      else
        robot.StopThumbs();
      end;
    end_procedure;

  end_switch;

  meter mWrist;
    gui
      owner = control_panel;
      position = 398, 53, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  meter mThumbs;
    gui
      owner = control_panel;
      position = 398, 98, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  switch swArm_Up;
    gui
      owner = control_panel;
      position = 50, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'UARROW.ICO';
    false_icon = 'UARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetArmPos( -1 );
      else
        robot.StopArm();
      end;
    end_procedure;

  end_switch;

  switch swWrist_Up;
    gui
      owner = control_panel;
      position = 142, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'UARROW.ICO';
    false_icon = 'UARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetWristPos( -1 );
      else
        robot.StopWrist();
      end;
    end_procedure;

  end_switch;

  switch swWrist_Down;
    gui
      owner = control_panel;
      position = 142, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'DARROW.ICO';
    false_icon = 'DARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetWristPos( 1 );
      else
        robot.StopWrist();
      end;
    end_procedure;

  end_switch;

  switch swHand_TurnLeft;
    gui
      owner = control_panel;
      position = 234, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'RARROW.ICO';
    false_icon = 'RARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.HandTurntableLeft();
      else
        robot.HandTurntableStop();
      end;
    end_procedure;

  end_switch;

  switch swHand_TurnRight;
    gui
      owner = control_panel;
      position = 234, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'LARROW.ICO';
    false_icon = 'LARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.HandTurntableRight();
      else
        robot.HandTurntableStop();
      end;
    end_procedure;

  end_switch;

  control set_rotate_angle;
    gui
      owner = control_panel;
      position = 914, 18, 95, 15;
    end_gui;
    output = ra;
    mode = horizontal_slider;
    range_to = 360;
    dec_places = 15;
    receivers = panel3d;
  end_control;

  control set_rotate_x;
    gui
      owner = control_panel;
      position = 914, 34, 95, 15;
    end_gui;
    output = rx;
    mode = horizontal_slider;
    range_to = 1;
    real_step = 0.001;
    dec_places = 15;
    receivers = panel3d;
  end_control;

  control set_rotate_y;
    gui
      owner = control_panel;
      position = 914, 50, 95, 15;
    end_gui;
    output = ry;
    mode = horizontal_slider;
    range_to = 1;
    init_value = 1;
    real_step = 0.001;
    dec_places = 15;
    receivers = panel3d;
  end_control;

  control set_rotate_z;
    gui
      owner = control_panel;
      position = 914, 66, 95, 15;
    end_gui;
    output = rz;
    mode = horizontal_slider;
    range_to = 1;
    real_step = 0.001;
    dec_places = 15;
    receivers = panel3d;
  end_control;

  meter mBase;
    gui
      owner = control_panel;
      position = 398, 8, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  meter mArm;
    gui
      owner = control_panel;
      position = 398, 23, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  meter mForearm;
    gui
      owner = control_panel;
      position = 398, 38, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  meter mHandSwing;
    gui
      owner = control_panel;
      position = 398, 68, 40, 14;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    frame = 0;
    font = font_text;
    colors
      ink = black;
      value = lgray;
    end_colors;
  end_meter;

  switch swArm_Down;
    gui
      owner = control_panel;
      position = 50, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'DARROW.ICO';
    false_icon = 'DARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetArmPos( 1 );
      else
        robot.StopArm();
      end;
    end_procedure;

  end_switch;

  switch swForearm_Up;
    gui
      owner = control_panel;
      position = 96, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'UARROW.ICO';
    false_icon = 'UARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetForearmPos( -1 );
      else
        robot.StopForearm();
      end;
    end_procedure;

  end_switch;

  switch swForearm_Down;
    gui
      owner = control_panel;
      position = 96, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'DARROW.ICO';
    false_icon = 'DARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
         robot.SetForearmPos( 1 );
      else
        robot.StopForearm();
      end;
    end_procedure;

  end_switch;

  switch swBase_Left;
    gui
      owner = control_panel;
      position = 4, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'LARROW.ICO';
    false_icon = 'LARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.BaseLeft();
      else
        robot.BaseStop();
      end;
    end_procedure;

  end_switch;

  switch swBase_Right;
    gui
      owner = control_panel;
      position = 4, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'RARROW.ICO';
    false_icon = 'RARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.BaseRight();
      else
        robot.BaseStop();
      end;
    end_procedure;

  end_switch;

  switch swHand_Left;
    gui
      owner = control_panel;
      position = 188, 30, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'LARROW.ICO';
    false_icon = 'LARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetHandPos( -1 );
      else
        robot.StopHand();
      end;
    end_procedure;

  end_switch;

  switch swHand_Right;
    gui
      owner = control_panel;
      position = 188, 60, 46, 30;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    true_icon = 'RARROW.ICO';
    false_icon = 'RARROW.ICO';
    logic = set_true_on_press;

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        robot.SetHandPos( 1 );
      else
        robot.StopHand();
      end;
    end_procedure;

  end_switch;

  switch swAuto;
    gui
      owner = control_panel;
      position = 608, 65, 37, 26;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    send_same_data = on;
    mode = text_button;
    init_value = true;
    true_text = 'STOP';
    false_text = 'RUN';

    procedure OnOutput( Output : boolean );
    begin
      pgController.SetAutoMode( Output );
    end_procedure;

  end_switch;

  meter mProgramStage;
    gui
      owner = control_panel;
      position = 619, 42, 25, 17;
    end_gui;
    mode = text_display;
    range_from = -999;
    range_to = 999;
    low_limit = -999;
    high_limit = 999;
    dec_places = 0;
    font = font_text;
    colors
      top_shadow = blue;
      bottom_shadow = blue;
      ink = blue;
      value = white;
    end_colors;
  end_meter;

  program startup;

    procedure OnActivate();
    begin
      Back.MoveTo( WorkX + WorkW / 2 - ( 1016 + NoZoomWinReduceW ) / 2, WorkY + WorkD / 2 - ( 741 + NoZoomWinReduceD ) / 2 );

      robot.SetSmoothingAngle( 80 );

      robot.RegisterGroup( 'Base2', 'Base1' );
      robot.RegisterGroup( 'Base3', 'Base1' );
      robot.RegisterGroup( 'Arm1', 'Base1' );

      robot.RegisterGroup( 'Arm2', 'Arm1' );
      robot.RegisterGroup( 'Arm3', 'Arm1' );
      robot.RegisterGroup( 'Arm4', 'Arm1' );
      robot.RegisterGroup( 'Forearm', 'Arm1' );

      robot.RegisterGroup( 'Wrist1', 'Forearm' );
      robot.RegisterGroup( 'Wrist2', 'Wrist1' );

      robot.RegisterGroup( 'Hand', 'Wrist1' );

      robot.RegisterGroup( 'HandTurntable', 'Hand' );

      robot.RegisterGroup( 'LeftThumb', 'HandTurntable' );
      robot.RegisterGroup( 'RightThumb', 'HandTurntable' );

      program_storage.LoadProgram();

      send robot;
      send pgController;
    end_procedure;

  end_program;

  program pgController;
    static
      IsAuto : boolean {init_value = true};
      GoUp : boolean;
      GoDown : boolean;
    end_static;


    procedure OnActivate();
    begin
      if robot.IsReady() and
         object.IsReady() then

        if IsAuto or GoUp then
          ActualStep = ActualStep + 1;
          if ActualStep > MaxStep then
            ActualStep = 1;
          end;
        elsif GoDown then
          ActualStep = ActualStep - 1;
          if ActualStep < 1 then
            ActualStep = MaxStep;
          end;
        else
          stop;
        end;

        mProgramStage.SetValue( ActualStep );

        robot.SetBasePos( baseArray[ ActualStep - 1 ] );
        robot.SetArmPos( armArray[ ActualStep - 1 ] );
        robot.SetForearmPos( forearmArray[ ActualStep - 1 ] );
        robot.SetWristPos( wristArray[ ActualStep - 1 ] );
        robot.SetHandPos( handArray[ ActualStep - 1 ] );
        robot.SetHandturntablePos( handturntableArray[ ActualStep - 1 ] );
        robot.SetThumbsPos( thumbsArray[ ActualStep - 1 ] );

        object.SetBasePos( objectrotationArray[ ActualStep - 1 ] );
        object.SetTranslationPos( objecttranslationArray[ ActualStep - 1 ] );

        if not IsAuto then
          swIsSparkle.SetValue( issparkleArray[ ActualStep - 1 ] );
          cntSparkleX.SetValue( sparklexArray[ ActualStep - 1 ] );
          cntSparkleY.SetValue( sparkleyArray[ ActualStep - 1 ] );
          cntSparkleZ.SetValue( sparklezArray[ ActualStep - 1 ] );
          cntSparkleDelay.SetValue( sparkledelayArray[ ActualStep - 1 ] );
        end;

        if issparkleArray[ ActualStep - 1 ] then
          yield;
          wait robot.IsReady() and object.IsReady();

          if ServoSound then
            sound 'servostop.wav';
            while wave_player_busy do
              yield;
            end;
          end;

          (* wait for end of all moves *)
          sparkle.Translate( sparklexArray[ ActualStep - 1 ], sparkleyArray[ ActualStep - 1 ], sparklezArray[ ActualStep - 1 ] );
          sparkle.SetValue( true );
          if WeldSound then
            sound 'welding.wav';
          end;
          weld = 100;
          pause sparkledelayArray[ ActualStep - 1 ];
          sparkle.SetValue( false );
          if ServoSound then
            sound 'servostart.wav';
          elsif WeldSound then
            sound 'stop.wav';
          end;
          weld = 0;
        end;

        GoUp = false;
        GoDown = false;

        if IsAuto then

          if ServoSound then
            if not wave_player_busy then
              sound 'servorun.wav';
            end;
          end;

          send self;
        end;

      else  (* if robot.IsReady() and object.IsReady() *)

        if ServoSound then
          if IsAuto then
            if not wave_player_busy then
              sound 'servorun.wav';
            end;
          end;
        end;

        send self;

      end;
    end_procedure;

    procedure SetAutoMode( Auto : boolean );
    begin
      if IsAuto <> Auto then
        IsAuto = Auto;
        send self;
      end;
    end_procedure;

    procedure StepUp();
    begin
      if not IsAuto then
        GoUp = true;
        send self;
      end;
    end_procedure;

    procedure StepDown();
    begin
      if not IsAuto then
        GoDown = true;
        send self;
      end;
    end_procedure;

  end_program;

  file program_storage;
    const
      filename1 = 'r2cabin.prg';
      filename2 = 'r2car.prg';
    end_const;


    procedure WriteRealArray( rn : array of real );
    var
      i : real;
    begin
      for i = loindex( rn ) to hiindex( rn ) do
        WrReal( rn[ i ] );
      end;
    end_procedure;

    procedure WriteBooleanArray( bn : array of boolean );
    var
      i : real;
    begin
      for i = loindex( bn ) to hiindex( bn ) do
        WrBool( bn[ i ] );
      end;
    end_procedure;

    procedure ReadRealArray( rn : array of real );
    var
      i : real;
    begin
      for i = loindex( rn ) to hiindex( rn ) do
        RdReal( &rn[ i ] );
      end;
    end_procedure;

    procedure ReadBooleanArray( bn : array of boolean );
    var
      i : real;
    begin
      for i = loindex( bn ) to hiindex( bn ) do
        RdBool( &bn[ i ] );
      end;
    end_procedure;

    procedure SaveProgram();
    var
      ok : boolean;
    begin
      if AltObject then
       Create( filename2, &ok );
      else
       Create( filename1, &ok );
      end;
      if ok then
        WriteRealArray( baseArray );
        WriteRealArray( armArray );
        WriteRealArray( forearmArray );
        WriteRealArray( wristArray );
        WriteRealArray( handArray );
        WriteRealArray( handturntableArray );
        WriteRealArray( thumbsArray );
        WriteRealArray( objectrotationArray );
        WriteRealArray( objecttranslationArray );
        WriteBooleanArray( issparkleArray );
        WriteRealArray( sparklexArray );
        WriteRealArray( sparkleyArray );
        WriteRealArray( sparklezArray );
        WriteRealArray( sparkledelayArray );
        WrReal( MaxStep );
        Close();
      else
      end;
    end_procedure;

    procedure LoadProgram();
    var
      i : cardinal;
      ok : boolean;
    begin
      if AltObject then
        OpenRead( filename2, &ok );
      else
        OpenRead( filename1, &ok );
      end;
      if ok then
        ReadRealArray( baseArray );
        ReadRealArray( armArray );
        ReadRealArray( forearmArray );
        ReadRealArray( wristArray );
        ReadRealArray( handArray );
        ReadRealArray( handturntableArray );
        ReadRealArray( thumbsArray );
        ReadRealArray( objectrotationArray );
        ReadRealArray( objecttranslationArray );
        ReadBooleanArray( issparkleArray );
        ReadRealArray( sparklexArray );
        ReadRealArray( sparkleyArray );
        ReadRealArray( sparklezArray );
        ReadRealArray( sparkledelayArray );
        RdReal( &MaxStep );
        Close();
        cntMaxStep.SetValue( MaxStep );
      else
      end;
    end_procedure;

  end_file;

end_instrument;

