directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data

  var
    ax : real {init_value = 0};
    az : real {init_value = 1};
  end_var;

end_data;

instrument

  panel control_panel;
    gui
      owner = background;
      position = 15, 680, 416, 70;
      window
        type = tool;
        title = 'Control Panel';
      end_window;
    end_gui;
    graphics_mode = opengl;
  end_panel;

  label label_2;
    gui
      owner = control_panel;
      position = 10, 18;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif', 8, bold;
      text = 'diffuse number';
    end_text_list;
    colors
      paper = color_btnhighlight;
    end_colors;
    blink_colors
      paper = color_btnhighlight;
    end_blink_colors;
  end_label;

  label label_3;
    gui
      owner = control_panel;
      position = 308, 22;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Arial', 14, bold;
      text = 'FPS';
    end_text_list;
    colors
      paper = color_btnhighlight;
    end_colors;
    blink_colors
      paper = color_btnhighlight;
    end_blink_colors;
  end_label;

  label label_3;
    gui
      owner = control_panel;
      position = 174, 24;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Arial', 14, bold;
      text = 'angle';
    end_text_list;
    colors
      paper = color_btnhighlight;
    end_colors;
    blink_colors
      paper = color_btnhighlight;
    end_blink_colors;
  end_label;

  control control_2;
    gui
      owner = control_panel;
      position = 232, 0, 72, 68;
    end_gui;
    range_to = 6.28;
    real_step = 0.02;
    transparent = true;

    procedure OnOutput( Output : real );
    begin
      ax = sin( Output );
      az = cos( Output );
    end_procedure;

  end_control;

  meter fps_meer;
    activity
      period = 0.5;
    end_activity;
    gui
      owner = control_panel;
      position = 352, 20, 54, 25;
    end_gui;
    mode = text_display;
    range_to = 10000;
    low_limit = 0;
    high_limit = 10000;
    dec_places = 0;
    font = 'Tahoma', 12, bold;
    colors
      border_paper = color_btnhighlight;
      paper = black;
      value = black;
      low_limit = black;
      high_limit = black;
    end_colors;
    blink_colors
      border_paper = color_btnhighlight;
    end_blink_colors;

    procedure OnActivate();
    var
      time : real;
    begin
      time = scene.GetRenderTime();
      if time <> 0 then
        self.SetValue( 1 / time );
      else
        self.SetValue( 9999 );
      end;
    end_procedure;

  end_meter;

  label label_2;
    gui
      owner = control_panel;
      position = 10, 44;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif', 8, bold;
      text = 'diffuse space';
    end_text_list;
    colors
      paper = color_btnhighlight;
    end_colors;
    blink_colors
      paper = color_btnhighlight;
    end_blink_colors;
  end_label;

  control light_number;
    gui
      owner = control_panel;
      position = 102, 42, 62, 18;
    end_gui;
    mode = count_box;
    range_from = 0.002;
    range_to = 0.025;
    init_value = 0.005;
    real_step = 0.001;
    dec_places = 3;

    procedure OnOutput( Output : real );
    begin
      scene.SetLightDiffuseSpace( 1, Output )
    end_procedure;

  end_control;

  control light_soft;
    gui
      owner = control_panel;
      position = 102, 16, 62, 18;
    end_gui;
    mode = count_box;
    range_to = 10;
    dec_places = 0;

    procedure OnOutput( Output : real );
    begin
      scene.SetLightDiffuseNumber( 1, Output );
    end_procedure;

  end_control;

  gl_scene scene;
    static
      Initialized : boolean;
      FireLCenterX : real;
      FireLCenterY : real;
      FireLCenterZ : real;
      FireLDirX : real;
      FireLDirY : real;
      FireLDirZ : real;
      LampLCenterX : real;
      LampLCenterY : real;
      LampLCenterZ : real;
      LampLPosX : real;
      LampLPosY : real;
      LampLPosZ : real;
      LampAngle : real;
      LampLen : real;
      LampFocusX : real;
      LampFocusY : real;
      LampFocusZ : real;
    end_static;

    activity
      period = 0.02;
    end_activity;
    gui
      owner = background;
      position = 15, 35, 800, 600;
      window
        type = normal;
        title = 'Fireplace';
      end_window;
    end_gui;
    light
      light0
        position = 0, 0.4, 0.5, 1;
      end_light0;
      light1
        ambient = 0.4, 0.3, 0.3, 1;
        diffuse = 0.4, 0.3, 0.3, 1;
        specular = 0.8, 0.5, 0.5, 1;
        position = -0.75, -0.61, -0.5, 1;
        diffuse_space = 0.01;
        flares_disabled = true;
      end_light1;
    end_light;
    volumetric_shadows = true;
    camera
      position = 0, 0, 1.12E+3;
      rotation = 0, 0;
      lens_flares = light_and_flares_fixed;
      flares_intensity = 0.8;
      flares_size = 0.5;
    end_camera;

    procedure OnActivate();
    static
      cnt = real, 0;
    begin
      if not Initialized then
        Initialize();
        Initialized = true;
      end;
    
      UpdateFirePos();
    
      cnt = cnt + 0.025;
      if cnt > ( 2 * Pi ) then
        cnt = cnt - ( 2 * Pi );
      end;
      LampAngle = sin( cnt ) * 30;
    
      UpdateLampPos();
    end_procedure;

    procedure SetLampAngle( Angle : real );
    begin
      LampAngle = Angle;
    end_procedure;

    procedure Initialize();
    const
      fireShiftY = -28;
      lampShiftY = 10;
    begin
      fireplace.GetLocationTranslate( FireLCenterX, FireLCenterY, FireLCenterZ );
      FireLCenterY = FireLCenterY + fireShiftY;
      FireLDirX = 0;
      FireLDirY = 0;
      FireLDirZ = 0;

      lamp.GetLocationTranslate( LampLCenterX, LampLCenterY, LampLCenterZ );
      LampLCenterY = LampLCenterY + lampShiftY;
      lampbar.RotationCenter( 0, 100, 0 );
      lamp.RotationCenter( 0, 200, 0 );
      LampLen = 200 + lampShiftY;
      LampFocusX = LampLCenterX;
      LampFocusY = LampLCenterY + 200 - lampShiftY;
      LampFocusZ = LampLCenterZ;
    end_procedure;

    procedure UpdateFirePos();
    const
      radius = 30;
      randstep = 3;
    var
      DirX = real;
      DirY = real;
      DirZ = real;
      Len = real;
    begin
      DirX = ( system.Rand() - 0.5 ) * randstep;
      DirY = ( system.Rand() - 0.5 ) * randstep;
      DirZ = ( system.Rand() - 0.5 ) * randstep;
      FireLDirX = FireLDirX + DirX;
      FireLDirY = FireLDirY + DirY;
      FireLDirZ = FireLDirZ + DirZ;
      Len = sqrt( FireLDirX * FireLDirX + FireLDirY * FireLDirY + FireLDirZ * FireLDirZ );
      if Len > radius then
        FireLDirX := ( FireLDirX / Len ) * radius;
        FireLDirY := ( FireLDirY / Len ) * radius;
        FireLDirZ := ( FireLDirZ / Len ) * radius;
      end;
    
      self.SetLightAbsPosition( 1,  FireLCenterX + FireLDirX, FireLCenterY + FireLDirY, FireLCenterZ + FireLDirZ, 1 );
    end_procedure;

    procedure ComputeRotation( var X, Y, Z : real; x, y, z, angle : real );
    static
      matrix : array [0..15] of real, 0;
      c : real, 0;
      s : real, 0;
      cc : real, 0;
      xin : real;
      yin : real;
      zin : real;
    begin
      (* build rotation matrix *)
      (* axis vector must be normalized for this matrix *)
      c := cos( Pi * ( angle / 180.0 ) );
      s := sin( Pi * ( angle / 180.0 ) );
      cc := 1.0 - c;
    
      matrix[ 3 ] = 0;
      matrix[ 7 ] = 0;
      matrix[ 11 ] = 0;
      matrix[ 12 ] = 0;
      matrix[ 13 ] = 0;
      matrix[ 14 ] = 0;
      matrix[ 15 ] = 1;
    
      matrix[ 0 ]  = ( x * x * cc ) + c;
      matrix[ 1 ]  = ( y * x * cc ) + ( z * s );
      matrix[ 2 ]  = ( x * z * cc ) - ( y * s );
      matrix[ 4 ]  = ( x * y * cc ) - ( z * s );
      matrix[ 5 ]  = ( y * y * cc ) + c;
      matrix[ 6 ]  = ( y * z * cc ) + ( x * s );
      matrix[ 8 ]  = ( x * z * cc ) + ( y * s );
      matrix[ 9 ]  = ( y * z * cc ) - ( x * s );
      matrix[ 10 ] = ( z * z * cc ) + c;

      (* transform vertex by this matrix -> multiply vertex by matrix *)
      xin = X;
      yin = Y;
      zin = Z;

      X := xin * matrix[ 0 ] + yin * matrix[ 4 ] + zin * matrix[ 8 ]  + matrix[ 12 ];
      Y := xin * matrix[ 1 ] + yin * matrix[ 5 ] + zin * matrix[ 9 ]  + matrix[ 13 ];
      Z := xin * matrix[ 2 ] + yin * matrix[ 6 ] + zin * matrix[ 10 ] + matrix[ 14 ];
    end_procedure;

    procedure UpdateLampPos();
    begin
      LampLPosX = 0;
      LampLPosY = -LampLen;
      LampLPosZ = 0;

      ComputeRotation( LampLPosX, LampLPosY, LampLPosZ, ax, 0, az, LampAngle );
      LampLPosX = LampLPosX + LampFocusX;
      LampLPosY = LampLPosY + LampFocusY;
      LampLPosZ = LampLPosZ + LampFocusZ;
      self.SetLightAbsPosition( 0,  LampLPosX, LampLPosY, LampLPosZ, 1 );

      lampbar.Rotate( LampAngle, ax, 0, az );
      lamp.Rotate( LampAngle, ax, 0, az );
    end_procedure;

  end_gl_scene;

  gl_shape gl_shape_1;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.200, 0.200, 0.200, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'aluminium01.jpg';
      end_item;
    end_material;
    location
      translate = -366, 91.8, -204;
      rotate = 0, 0, 0, 1;
      scale = 2.02, 27, 2.05;
    end_location;
    look = cylinder;
    y_tex_repeat = 20;
  end_gl_shape;

  gl_fire fire;
    activity
      period = infinite;
    end_activity;
    gui
      owner = scene;
    end_gui;
    location
      translate = -347, -216, -187;
      rotate = 0, 0, 0, 1;
      scale = 0.4642, 0.4, 0.4642;
    end_location;
    expression = true;
    transparecy_gamma_correction = 0.6;
    particles = 30;
  end_gl_fire;

  gl_shape lampbar;
    gui
      owner = scene;
    end_gui;
    location
      translate = 6.1E-5, 42, 215;
      rotate = 0, 0, 0, 1;
      scale = 0.2, 10, 0.2;
      origin = 0, 20, 0;
    end_location;
    common_3D
      disable_launch_repaint = true;
    end_common_3D;
  end_gl_shape;

  gl_shape lamp;
    gui
      owner = scene;
    end_gui;
    location
      translate = -0.2057, 139, 216;
      rotate = 0, 0, 0, 1;
      scale = 4.09, 1.53, 3.8;
    end_location;
    common_3D
      disable_launch_repaint = true;
    end_common_3D;
    look = open_cone;
  end_gl_shape;

  gl_poster ceiling;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'woods01.jpg';
      end_item;
    end_material;
    location
      translate = 43.6, 332, 41.9;
      rotate = 90, 1, 0, 0;
      scale = 6.34, 4.67, 1;
    end_location;
    common_3D
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 4;
    x_tex_repeat = 2;
  end_gl_poster;

  gl_poster leftwall;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'colornoise01.jpg';
        normalmap = 'noise01_normalmap.jpg';
        heightmap = 'noise01_heightmap.jpg';
      end_item;
    end_material;
    location
      translate = -460, 16.4, 48.2;
      rotate = 90, 0, 1, 0;
      scale = 4.59, 3.94, 1;
    end_location;
    common_3D
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 2;
    x_tex_repeat = 2;
  end_gl_poster;

  gl_poster rightwall;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'colornoise01.jpg';
        normalmap = 'noise01_normalmap.jpg';
        heightmap = 'noise01_heightmap.jpg';
      end_item;
    end_material;
    location
      translate = 528, 12.5, 40.1;
      rotate = 90, 0, -1, 0;
      scale = 4.74, 3.99, 1;
    end_location;
    common_3D
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 2;
    x_tex_repeat = 2;
  end_gl_poster;

  gl_model fireplace;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'BLACK MATTE';
        ambient = 0.098, 0.064, 0.000, 1.000;
        diffuse = 0.045, 0.000, 0.000, 1.000;
        specular = 0.330, 0.201, 0.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.050;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
      item
        name = 'GRANITE';
        ambient = 0.073, 0.045, 0.036, 1.000;
        diffuse = 0.266, 0.220, 0.119, 1.000;
        specular = 0.652, 0.652, 0.652, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.280;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
      item
        name = 'BEIGE MATTE';
        ambient = 0.100, 0.045, 0.009, 1.000;
        diffuse = 0.137, 0.064, 0.027, 1.000;
        specular = 0.201, 0.100, 0.027, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.155;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
      end_item;
    end_material;
    location
      translate = -342, -191, -187;
      rotate = 47, -0.0446, 0.999, 0.0049;
      scale = 1, 1, 1;
    end_location;
    file = 'FIREPLAC.3DS';
  end_gl_model;

  gl_poster backwall;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'stones01_ambient.bmp';
        normalmap = 'stones01_normalmap.bmp';
        heightmap = 'stones01_heightmap.bmp';
      end_item;
    end_material;
    location
      translate = 35.6, 25.9, -311;
      rotate = 0, 0, 0, 1;
      scale = 6.16, 4.01, 1;
    end_location;
    common_3D
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 3;
    x_tex_repeat = 4;
  end_gl_poster;

  gl_model desk;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'MARBLE PALE SCLP';
        ambient = 0.137, 0.000, 0.009, 1.000;
        diffuse = 0.422, 0.000, 0.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.183;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'wood10.jpg';
      end_item;
    end_material;
    location
      translate = -21.9, -240, -102;
      rotate = 44.1, 0, 1, 0;
      scale = 1, 1, 1;
    end_location;
    file = 'STONEBEN.3DS';
  end_gl_model;

  gl_poster floor;
    gui
      owner = scene;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 0.800;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.019;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'parquet03.jpg';
      end_item;
    end_material;
    location
      translate = 44.3, -295, 24.1;
      rotate = 90, -1, 0, 0;
      scale = 6.3, 5.07, 1;
    end_location;
    common_3D
      disable_volumetric_shadows = true;
    end_common_3D;
    y_tex_repeat = 5;
    x_tex_repeat = 5;
    reflections = true;
    reflections_type = subtractive;
  end_gl_poster;

end_instrument;

