directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = true;
    activate_receivers = true;
    output_action = set_local;
  end_startup_options;
end_settings;


driver
end_driver;

data

  var
    a : real;
  end_var;

end_data;

instrument

  panel control;
    gui
      owner = background;
      position = 835, 35, 190, 600;
      gravity = right, bottom;
      window
        type = tool;
        title = 'Control Panel';
      end_window;
    end_gui;
  end_panel;

  switch cswitch_1;
    gui
      owner = control;
      position = 146, 573, 40, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    startup_options
      call_procedures = false;
      activate_receivers = false;
    end_startup_options;
    mode = text_button;
    init_value = true;
    true_text = 'Run';
    false_text = 'Stop';

    procedure OnOutput( Output : boolean );
    begin
      rotor.SetRun( Output );
    end_procedure;

  end_switch;

  switch cswitch_1;
    gui
      owner = control;
      position = 92, 573, 49, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    startup_options
      call_procedures = false;
      activate_receivers = false;
    end_startup_options;
    mode = text_button;
    true_text = 'Env. on';
    false_text = 'Env. off';

    procedure OnOutput( Output : boolean );
    begin
      glwindow.SphereMapEnvironment( Output );
      if Output then
        model.EnableTextureLayer( 2 );
      else
        model.DisableTextureLayer( 2 );
      end;
    end_procedure;

  end_switch;

  switch model_switch;
    gui
      owner = control;
      position = 5, 574, 81, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Low Polygon';
    false_text = 'High Polygon';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        model.LoadModel( 'cwblocks.obj' );
        model.Translate( 0, 32, 0 );
        model.Scale( 0.65, 0.65, 0.65 );
      else
        model.LoadModel( 'diablo.obj' );
        model.Translate( 0, 0, 0 );
        model.Scale( 1, 1, 1 );
      end;
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control;
      position = 31, 520;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'floor reflections type';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control;
      position = 22, 427;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'turntable reflections type';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control;
      position = 15, 295;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'right glass reflections type';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control;
      position = 14, 163;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'center glass reflections type';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control;
      position = 22, 41;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'left glass reflections type';
    end_text_list;
  end_label;

  switch right_type;
    gui
      owner = control;
      position = 57, 313, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Aditive';
    false_text = 'Subtractive';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        glass3.SetAditiveReflectionsType();
      else
        glass3.SetSubtractiveReflectionsType();
      end;
    end_procedure;

  end_switch;

  switch center_type;
    gui
      owner = control;
      position = 57, 180, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Aditive';
    false_text = 'Subtractive';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        glass2.SetAditiveReflectionsType();
      else
        glass2.SetSubtractiveReflectionsType();
      end;
    end_procedure;

  end_switch;

  switch left_type;
    gui
      owner = control;
      position = 57, 56, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Aditive';
    false_text = 'Subtractive';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        glass1.SetAditiveReflectionsType();
      else
        glass1.SetSubtractiveReflectionsType();
      end;
    end_procedure;

  end_switch;

  switch turntable_type;
    gui
      owner = control;
      position = 57, 445, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Aditive';
    false_text = 'Subtractive';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        turntable.SetAditiveReflectionsType();
      else
        turntable.SetSubtractiveReflectionsType();
      end;
    end_procedure;

  end_switch;

  switch floor_type;
    gui
      owner = control;
      position = 57, 536, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Aditive';
    false_text = 'Subtractive';

    procedure OnOutput( Output : boolean );
    begin
      if Output then
        floor.SetAditiveReflectionsType();
      else
        floor.SetSubtractiveReflectionsType();
      end;
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control;
      position = 9, 338;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'right glass transparent mirror';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control;
      position = 4, 202;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'center glass transparent mirror';
    end_text_list;
  end_label;

  switch right_transparency;
    gui
      owner = control;
      position = 57, 354, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    init_value = true;
    true_text = 'On';
    false_text = 'Off';

    procedure OnOutput( Output : boolean );
    begin
      glass3.TransparentMirror( Output );
    end_procedure;

  end_switch;

  switch center_transparency;
    gui
      owner = control;
      position = 57, 219, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    init_value = true;
    true_text = 'On';
    false_text = 'Off';

    procedure OnOutput( Output : boolean );
    begin
      glass2.TransparentMirror( Output );
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control;
      position = 11, 77;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'left glass transparent mirror';
    end_text_list;
  end_label;

  switch left_transparency;
    gui
      owner = control;
      position = 57, 92, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    init_value = true;
    true_text = 'On';
    false_text = 'Off';

    procedure OnOutput( Output : boolean );
    begin
      glass1.TransparentMirror( Output );
    end_procedure;

  end_switch;

  switch right_mirror;
    gui
      owner = control;
      position = 57, 271, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'On';
    false_text = 'Off';

    procedure OnOutput( Output : boolean );
    begin
      glass3.Reflections( Output );
      if Output then
        right_transparency.Enable();
        right_type.Enable();
      else
        right_transparency.Disable();
        right_type.Disable();
      end;
    end_procedure;

  end_switch;

  switch left_mirror;
    gui
      owner = control;
      position = 57, 18, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'On';
    false_text = 'Off';

    procedure OnOutput( Output : boolean );
    begin
      glass1.Reflections( Output );
      if Output then
        left_transparency.Enable();
        left_type.Enable();
      else
        left_transparency.Disable();
        left_type.Disable();
      end;
    end_procedure;

  end_switch;

  switch center_mirror;
    gui
      owner = control;
      position = 57, 141, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'On';
    false_text = 'Off';

    procedure OnOutput( Output : boolean );
    begin
      glass2.Reflections( Output );
      if Output then
        center_transparency.Enable();
        center_type.Enable();
      else
        center_transparency.Disable();
        center_type.Disable();
     end;
    end_procedure;

  end_switch;

  switch cswitch_4;
    gui
      owner = control;
      position = 57, 403, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'On';
    false_text = 'Off';

    procedure OnOutput( Output : boolean );
    begin
      turntable.Reflections( Output );
      if Output then
        turntable_type.Enable();
      else
        turntable_type.Disable();
      end;
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control;
      position = 25, 124;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'center glass reflections';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control;
      position = 30, 255;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'right glass reflections';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control;
      position = 34, 388;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'turntable reflections';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = control;
      position = 34, 3;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'left glass reflections';
    end_text_list;
  end_label;

  switch sw1_floor;
    gui
      owner = control;
      position = 57, 497, 74, 21;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    init_value = true;
    true_text = 'On';
    false_text = 'Off';

    procedure OnOutput( Output : boolean );
    begin
      floor.Reflections( Output );
      if Output then
        floor_type.Enable();
      else
        floor_type.Disable();
      end;
    end_procedure;

  end_switch;

  label label_2;
    gui
      owner = control;
      position = 47, 481;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      text = 'floor reflections';
    end_text_list;
  end_label;

  gl_scene glwindow;
    gui
      owner = background;
      position = 15, 35, 800, 600;
      gravity = right, bottom;
      window
        type = normal;
        title = 'Reflections';
      end_window;
    end_gui;
    material
      item
        name = 'sphere_map';
        ambient = 0.330, 0.229, 0.155, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'env.bmp';
      end_item;
    end_material;
    light
      light0
        position = -2, 2, 2, 1;
      end_light0;
    end_light;
    camera
      position = 0, 0, 1.12E+3;
      rotation = 0, 0;
    end_camera;
  end_gl_scene;

  gl_shape beam1;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'stones11.jpg';
      end_item;
    end_material;
    location
      translate = 0.7107, 328, -206;
      rotate = 0, 0, 0, 1;
      scale = 21.1, 1.11, 1.33;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    y_tex_repeat = 0.165;
    x_tex_repeat = 2;
  end_gl_shape;

  gl_shape beam2;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'stones11.jpg';
      end_item;
    end_material;
    location
      translate = -397, 327, -58.4;
      rotate = 42, 0, 1, 0;
      scale = 23.3, 1.11, 1.33;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    y_tex_repeat = 0.165;
    x_tex_repeat = 2;
  end_gl_shape;

  gl_shape beam3;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'stones11.jpg';
      end_item;
    end_material;
    location
      translate = 394, 328, -60.7;
      rotate = 42, 0, -1, 0;
      scale = 23.2, 1.11, 1.33;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    y_tex_repeat = 0.165;
    x_tex_repeat = 2;
  end_gl_shape;

  gl_poster turntable;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.050, 0.050, 0.050, 1.000;
        diffuse = 0.500, 0.500, 0.500, 0.743;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.266;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'marble03.jpg';
      end_item;
    end_material;
    location
      translate = 17.4, -161, 231;
      rotate = 90, -1, 0, 0;
      scale = 2.04, 2.11, 0.0511;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    look = look_2;
    reflections_type = subtractive;
  end_gl_poster;

  gl_poster glass1;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 0.321;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.155;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'slate01.jpg';
      end_item;
    end_material;
    location
      translate = -369, 66.8, -32.3;
      rotate = 42, 0, 1, 0;
      scale = 2.62, 3.11, 1.25;
    end_location;
    common_3D
      disable_planar_shadows = true;
      disable_environment_mapping = true;
    end_common_3D;
    reflections_type = subtractive;
    transparent_mirror = true;
  end_gl_poster;

  gl_poster glass2;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 0.321;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.155;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'slate01.jpg';
      end_item;
    end_material;
    location
      translate = 0.0576, 67.4, -197;
      rotate = 0, 0, 1, 0;
      scale = 2.62, 3.11, 1.25;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    reflections_type = subtractive;
    transparent_mirror = true;
  end_gl_poster;

  gl_poster glass3;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 0.321;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.155;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'slate01.jpg';
      end_item;
    end_material;
    location
      translate = 370, 68.1, -32.3;
      rotate = -42, 0, 1, 0;
      scale = 2.62, 3.11, 1.25;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    reflections_type = subtractive;
    transparent_mirror = true;
  end_gl_poster;

  gl_poster background;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.200, 0.200, 0.200, 1.000;
        diffuse = 0.009, 0.000, 0.009, 1.000;
        specular = 0.000, 0.000, 0.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.000;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'photo01.jpg';
      end_item;
    end_material;
    location
      translate = -87.6, 288, -887;
      rotate = 0, 0, 0, 1;
      scale = 15.2, 8.16, 1;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
  end_gl_poster;

  gl_shape pylon1;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'stones11.jpg';
      end_item;
    end_material;
    location
      translate = 214, 68.2, -205;
      rotate = 0, 0, 0, 1;
      scale = 1.75, 25, 1.63;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    look = open_cylinder;
  end_gl_shape;

  gl_shape pylon2;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'stones11.jpg';
      end_item;
    end_material;
    location
      translate = -548, 67.1, 98.8;
      rotate = 0, 0, 0, 1;
      scale = 1.75, 25, 1.63;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    look = open_cylinder;
  end_gl_shape;

  gl_shape pylon3;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'stones11.jpg';
      end_item;
    end_material;
    location
      translate = 532, 66.3, 110;
      rotate = 0, 0, 0, 1;
      scale = 1.75, 25, 1.63;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    look = open_cylinder;
  end_gl_shape;

  gl_shape pylon4;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'stones11.jpg';
      end_item;
    end_material;
    location
      translate = -214, 69.4, -201;
      rotate = 0, 0, 0, 1;
      scale = 1.75, 25, 1.63;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    look = open_cylinder;
  end_gl_shape;

  gl_shape rotor;
    static
      a : real;
      run : boolean {init_value = true};
    end_static;

    activity
      period = 0.05;
    end_activity;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.100, 0.100, 0.100, 1.000;
        diffuse = 1.000, 1.000, 1.000, 1.000;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.508;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'marble03.jpg';
      end_item;
    end_material;
    location
      translate = 17.6, -171, 230;
      rotate = 0, 0, 0, 1;
      scale = 16.4, 1.01, 16.8;
    end_location;
    common_3D
      disable_environment_mapping = true;
    end_common_3D;
    look = open_cylinder;

    procedure OnActivate();
    begin
      if run then
        a = a + 0.5;
        if a > 360 then
          a = a - 360;
        end;
        self.Rotate( a, 0, 1, 0 );
        turntable.Rotate( a, 0, 0, 1 );
        model.Rotate( a, 0, 1, 0 );
      end;
    end_procedure;

    procedure SetRun( set : boolean );
    begin
      run = set;
    end_procedure;

  end_gl_shape;

  gl_model model;
    gui
      owner = glwindow;
    end_gui;
    location
      translate = 10.4, -107, 224;
      rotate = 0, 0, 0, 1;
      scale = 2.18, 2.12, 2.18;
    end_location;
    file = 'diablo.obj';
  end_gl_model;

  gl_poster floor;
    gui
      owner = glwindow;
    end_gui;
    material
      item
        name = 'surface';
        ambient = 0.250, 0.250, 0.250, 1.000;
        diffuse = 1.000, 1.000, 1.000, 0.504;
        specular = 1.000, 1.000, 1.000, 1.000;
        emissive = 0.000, 0.000, 0.000, 1.000;
        shininess = 0.366;
        image_format = rgb;
        texture_filter = linear;
        blending_mode = all_components;
        transparency_gamma = 1.000;
        glow = false;
        texture = 'marble01.gif';
      end_item;
    end_material;
    location
      translate = -5.08, -181, 267;
      rotate = 90, -1, 0, 0;
      scale = 7.27, 7.27, 0.0021;
    end_location;
    common_3D
      disable_volumetric_shadows = true;
      disable_environment_mapping = true;
    end_common_3D;
    look = look_2;
    reflections = true;
    reflections_type = subtractive;
  end_gl_poster;

end_instrument;

