directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
end_settings;

driver
end_driver;

data

  var
    x : array[ 1..20 ] of cardinal;
    y : array[ 1..20 ] of cardinal;
    ratio : array[ 1..20 ] of real;
    num_found : cardinal;
    x_mask : array[ 1..20 ] of cardinal;
    y_mask : array[ 1..20 ] of cardinal;
    ratio_mask : array[ 1..20 ] of real;
    num_found_mask : cardinal;
    min_ratio : real;
  end_var;

end_data;

instrument

  panel panel_1;
    gui
      owner = background;
      position = 24, 40, 1311, 785;
      window
        type = normal;
      end_window;
    end_gui;
  end_panel;

  image image_1;
    gui
      owner = panel_1;
      position = 16, 590, 165, 185;
    end_gui;
    file = 'c_pattern.png';
  end_image;

  image image_1;
    gui
      owner = panel_1;
      position = 1136, 590, 165, 185;
    end_gui;
    file = 'mask_draw.PNG';
  end_image;

  label label_3;
    gui
      owner = panel_1;
      position = 746, 595;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif (Central European)', 10, normal;
      text = 'found patterns';
    end_text_list;
  end_label;

  label label_3;
    gui
      owner = panel_1;
      position = 616, 710;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif (Central European)', 10, normal;
      text = 'Minimum ratio';
    end_text_list;
  end_label;

  control control_7;
    gui
      owner = panel_1;
      position = 596, 675, 135, 38;
    end_gui;
    output = min_ratio;
    mode = horizontal_potentiometer;
    content = med;
    range_to = 1;
    init_value = 0.75;
    real_step = 0.05;
  end_control;

  meter meter_4;
    gui
      owner = panel_1;
      position = 696, 590, 50, 26;
    end_gui;
    expression = num_found_mask;
    mode = text_display;
    dec_places = 0;
    font = font_caption;
    colors
      ink = black;
      paper = color_btnface;
      low_limit = color_btnface;
      high_limit = color_btnface;
    end_colors;
  end_meter;

  label label_2;
    gui
      owner = panel_1;
      position = 941, 585;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Verdana (Central European)', 20, normal;
      text = 'ACTIVE MASK';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = panel_1;
      position = 201, 585;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Verdana (Central European)', 20, normal;
      text = 'NO MASK';
    end_text_list;
  end_label;

  switch switch_5;
    gui
      owner = panel_1;
      position = 446, 675, 61, 31;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Next image';
    false_text = 'Next image';

    procedure OnOutput( Output : boolean );
    begin
        send camera_1;
    end_procedure;

  end_switch;

  meter meter_3;
    gui
      owner = panel_1;
      position = 466, 590, 50, 26;
    end_gui;
    expression = num_found;
    mode = text_display;
    dec_places = 0;
    font = font_caption;
    colors
      ink = black;
      paper = color_btnface;
      low_limit = color_btnface;
      high_limit = color_btnface;
    end_colors;
  end_meter;

  camera camera_1;
    activity
      period = infinite;
    end_activity;
    gui
      owner = panel_1;
      position = 661, 65, 650, 515;
    end_gui;
    camera_type = image_file;
    camera_files = 'c1.PNG', 'c2.PNG';
    frame_mode = on_activate;
    frame_rate = 0.5;
    scale_units = 'px';
    scale_units_long = 'pixely';
    image_processing
      init_data
        frame_file frame_1;
          path = 'c_pattern.png';
          mask_path = 'c2_mask.bmp';
        end_frame_file;
        frame_file frame_4;
          path = '';
          mask_path = '';
        end_frame_file;
        frame_file frame_2;
          path = 'c_pattern.png';
          mask_path = '';
        end_frame_file;
        number min_ratio;
          value = 0 set min_ratio;
        end_number;
      end_init_data;
      steps
        step pattern_match_monochrome;
          condition = true;
          input = source, , frame_1, 0, 0.5, min_ratio, 10, , true;
          output = num_found_mask, pattern_match_monochrome_0_coordinate_system_2, pattern_found_mask, pattern_ratio_mask;
        end_step;
      end_steps;
      output_data
        frame frame_1;
        end_frame;
        rectangle pattern_found_mask;
          x = x_mask;
          y = y_mask;
        end_rectangle;
        number pattern_ratio_mask;
          value = ratio_mask;
        end_number;
        number num_found_mask;
          value = num_found_mask;
        end_number;
        frame frame_2;
        end_frame;
      end_output_data;
    end_image_processing;
    overlay_colors
      drawing_level = min;
    end_overlay_colors;
    avi
      file_history = hour;
    end_avi;
    editor_options
      clear_overlay_before_step = false;
      auto_repeat_start_delay = 100;
      auto_repeat_result_delay = 400;
      edit_color = lred;
      coord_color = lblue;
      editor_exp_time = 0;
      editor_max_exp_time = 8;
      editor_gain = 0;
      editor_max_gain = 65535;
      splitters = 0.5709779263, 0.5, 0.1666666716, 0.8333333135;
      window_maximized = true;
      window = -4, -4, 1688, 1028;
      light_1_enable = false;
      light_2_enable = false;
      light_3_enable = false;
      light_4_enable = false;
      light_1_flash = false;
      light_2_flash = false;
      light_3_flash = false;
      light_4_flash = false;
      light_1_intensity = 0;
      light_2_intensity = 0;
      light_3_intensity = 0;
      light_4_intensity = 0;
    end_editor_options;

    procedure OnImage();
    var
      i : cardinal;
    begin
      for i := 1 to num_found_mask do
        WriteString('ratio: ' + str(ratio_mask[i], 10), x_mask[i] - 50, y_mask[i]-50, 0, 19, 255, 0, 255, 255);
      end;
      send meter_4;
    end_procedure;

  end_camera;

  label label_3;
    gui
      owner = panel_1;
      position = 521, 595;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Microsoft Sans Serif (Central European)', 10, normal;
      text = 'found patterns';
    end_text_list;
  end_label;

  label label_2;
    gui
      owner = panel_1;
      position = 446, 10;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    text_list
      font = 'Verdana (Central European)', 20, normal;
      text = 'Influence of pattern mask definition';
    end_text_list;
  end_label;

  camera camera_1;
    activity
      period = infinite;
    end_activity;
    gui
      owner = panel_1;
      position = -4, 65, 650, 515;
    end_gui;
    camera_type = image_file;
    camera_files = 'c1.PNG', 'c2.PNG';
    frame_mode = on_activate;
    scale_units = 'px';
    scale_units_long = 'pixely';
    image_processing
      init_data
        frame_file frame_1;
          path = 'c_pattern.png';
          mask_path = 'c2_mask.bmp';
        end_frame_file;
        frame_file frame_4;
          path = '';
          mask_path = '';
        end_frame_file;
        frame_file frame_2;
          path = 'c_pattern.png';
          mask_path = '';
        end_frame_file;
        number min_ratio;
          value = 0 set min_ratio;
        end_number;
      end_init_data;
      steps
        step pattern_match_monochrome;
          condition = true;
          input = source, , frame_2, 0, 0.5, min_ratio, 10, , true;
          output = num_found, pattern_match_monochrome_1_coordinate_system_2, pattern_found, pattern_ratio;
        end_step;
      end_steps;
      output_data
        frame frame_1;
        end_frame;
        rectangle pattern_found;
          x = x;
          y = y;
        end_rectangle;
        number pattern_ratio;
          value = ratio;
        end_number;
        number num_found;
          value = num_found;
        end_number;
      end_output_data;
    end_image_processing;
    overlay_colors
      drawing_level = min;
    end_overlay_colors;
    avi
      file_history = hour;
    end_avi;
    editor_options
      clear_overlay_before_step = false;
      auto_repeat_start_delay = 100;
      auto_repeat_result_delay = 400;
      edit_color = lred;
      coord_color = lblue;
      editor_exp_time = 0;
      editor_max_exp_time = 8;
      editor_gain = 0;
      editor_max_gain = 65535;
      splitters = 0.5709779263, 0.5, 0.1666666716, 0.8333333135;
      window_maximized = true;
      window = -4, -4, 1688, 1028;
      light_1_enable = false;
      light_2_enable = false;
      light_3_enable = false;
      light_4_enable = false;
      light_1_flash = false;
      light_2_flash = false;
      light_3_flash = false;
      light_4_flash = false;
      light_1_intensity = 0;
      light_2_intensity = 0;
      light_3_intensity = 0;
      light_4_intensity = 0;
    end_editor_options;

    procedure OnImage();
    var
      i : cardinal;
    begin
      for i := 1 to num_found do
        WriteString('ratio: ' + str(ratio[i], 10), x[i] - 50, y[i], 0, 19, 0, 255, 0, 255);
      end;
      send meter_3;
    end_procedure;

  end_camera;

end_instrument;

