directories
end_directories;

settings
  operation_mode = real_time;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
end_settings;

driver
end_driver;

data

  var
    NumberOfCircles : cardinal;
  end_var;

end_data;

instrument

  panel panel_1;
    gui
      owner = background;
      position = 35, 115, 415, 310;
      window
        type = normal;
        title = 'circle_detection_by_threshold';
      end_window;
    end_gui;

    procedure OnWindowClose();
    begin
      core.StopApplication();
    end_procedure;

  end_panel;

  label label_4;
    gui
      owner = panel_1;
      position = 315, 40;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    transparent = true;
    text_list
      text = 'Number of circles:';
    end_text_list;
  end_label;

  meter meter_NOC;
    gui
      owner = panel_1;
      position = 330, 70, 53, 70;
    end_gui;
    mode = text_display;
    low_limit = 0;
    high_limit = 100;
    dec_places = 0;
    justify = center;
    font = 'Arial (Central European)', 48, bold;
    text_shift = -5;
    colors
      ink = black;
      paper = black;
      value = white;
      low_limit = white;
      high_limit = white;
    end_colors;
  end_meter;

  camera camera_1;
    activity
      period = 1;
    end_activity;
    gui
      owner = panel_1;
      position = 15, 15, 280, 280;
    end_gui;
    camera_type = image_file;
    camera_files = 'Circles6.JPG', 'Circles1.JPG', 'Circles2.JPG', 'Circles3.JPG', 'Circles4.JPG', 'Circles5.JPG';
    exp_time = 0;
    max_exp_time = 8;
    frame_mode = on_activate;
    scale_units = 'px';
    scale_units_long = 'pixely';
    image_processing
      init_data
        flag condition;
          value = true;
        end_flag;
      end_init_data;
      steps
        step circle_detection_by_threshold;
          condition = true;
          input = source, , 10, 10, 0.5, 0.5, false, true;
          output = NoOfCircles, circle_detection_by_threshold_0_ring_2;
        end_step;
      end_steps;
      output_data
        number NoOfCircles;
          value = NumberOfCircles;
        end_number;
      end_output_data;
    end_image_processing;
    avi
      folder_history = day;
      file_history = hour;
    end_avi;

    procedure OnImage();
      begin
        core.DebugOutput( 'action: ', NumberOfCircles );
        meter_NOC.SetValue( NumberOfCircles );
    end_procedure;

  end_camera;

  box box_2;
    gui
      owner = panel_1;
      position = 10, 10, 290, 290;
    end_gui;
    colors
      interior = black;
    end_colors;
  end_box;

end_instrument;

