directories
end_directories;

settings
  operation_mode = real_time;
  kernel_timer_resolution = high;
  time_error_limit = infinite;
  output_timeout = 1;
  startup_options
    call_procedures = false;
    activate_receivers = false;
    output_action = set_local;
  end_startup_options;
  log_window
    enabled = false;
  end_log_window;
end_settings;

driver
end_driver;

data

  const
    bsDO5 = '01010101;10101010;11111111;01111111;10111111;11011111;11101111;11110111;11111011;11111101;11111110;10000000;01000000;00100000;00010000;00001000;00000100;00000010;00000001;00000000;';
    trhBackgroundLum = 0.1;
    trhRandError = 0.7;
    lastFrame = 21;
    sTestRun = 'Test of module DO2 is running...';
    sReady = 'Click "Start" button to run test.';
    sPrepare = 'Data reading, module identification...';
    tmTestAutoRepeat = 20;
    tmDelayLogoShow = 5;
  end_const;

  var
    Frame : longint;
    DO : cardinal;
    Error : boolean;
    CopyFrameCondition : boolean;
    PatternMatchCondition : boolean;
    SetCoordinateSysCondition : boolean;
    GetColorCondition : boolean;
    CoordinateSys_x : real;
    CoordinateSys_y : real;
    CoordinateSys_a : real;
    PatternMatchNumber : longcard;
    LedLum : array[ 1..8 ] of real {mask = '#.###'};
    LedHue : array[ 1..8 ] of real {mask = '###.#'};
  end_var;

end_data;

instrument

  panel pa_LedCheck;
    gui
      owner = background;
      position = 3, 22, 640, 600;
      window
        type = normal;
        title = 'VisionLab - Get color example';
        disable = zoom, minimize, maximize;
      end_window;
    end_gui;

    procedure OnStartup();
    var
      x : longint;
      w : longint;
      d : longint;
    begin
      me_Progress.Hide();
      GetRect( x, x, w, d );
      MoveTo( WorkX + (WorkW - w) / 2, WorkY + (WorkD - d) / 2 );
    end_procedure;

    procedure OnWindowClose();
    begin
      system.StopApplication();
    end_procedure;

    procedure SetLED( bsout : shortcard );
    begin
      in_DO1.SetValue( bitget( bsout, 0 ) = 1 );
      in_DO2.SetValue( bitget( bsout, 1 ) = 1 );
      in_DO3.SetValue( bitget( bsout, 2 ) = 1 );
      in_DO4.SetValue( bitget( bsout, 3 ) = 1 );
      in_DO5.SetValue( bitget( bsout, 4 ) = 1 );
      in_DO6.SetValue( bitget( bsout, 5 ) = 1 );
      in_DO7.SetValue( bitget( bsout, 6 ) = 1 );
      in_DO8.SetValue( bitget( bsout, 7 ) = 1 );
    end_procedure;

    procedure SetLED_Err( bs : shortcard );
    begin
      in_DO1_Err.SetValue( bitget( bs, 0 ) = 1 );
      in_DO2_Err.SetValue( bitget( bs, 1 ) = 1 );
      in_DO3_Err.SetValue( bitget( bs, 2 ) = 1 );
      in_DO4_Err.SetValue( bitget( bs, 3 ) = 1 );
      in_DO5_Err.SetValue( bitget( bs, 4 ) = 1 );
      in_DO6_Err.SetValue( bitget( bs, 5 ) = 1 );
      in_DO7_Err.SetValue( bitget( bs, 6 ) = 1 );
      in_DO8_Err.SetValue( bitget( bs, 7 ) = 1 );
    end_procedure;

  end_panel;

  panel pa_Camera;
    gui
      owner = pa_LedCheck;
      position = 0, 70, 640, 480;
    end_gui;

    procedure OnStartup();
    begin
      Hide();
    end_procedure;

  end_panel;

  camera ca_ImageFile;
    gui
      owner = pa_Camera;
      position = 0, 0, 640, 480;
    end_gui;
    camera_type = image_file;
    camera_files = 'Module_Init.png', 'Module_Step_0.png', 'Module_Step_1.png', 'Module_Step_2.png', 'Module_Step_3.png', 'Module_Step_4.png', 'Module_Step_5.png', 'Module_Step_6.png', 'Module_Step_7.png', 'Module_Step_8.png', 'Module_Step_9.png', 'Module_Step_10.png', 'Module_Step_11.png', 'Module_Step_12.png', 'Module_Step_13.png', 'Module_Step_14.png', 'Module_Step_15.png', 'Module_Step_16.png', 'Module_Step_17.png', 'Module_Step_18.png', 'Module_Step_19.png', 'Module_Step_20.png';
    exp_time = 0.104;
    max_exp_time = 8;
    frame_mode = on_activate;
    frame_rate = 5;
    white_balance_ratios = 1.4, 1.7;
    scale_units = 'px';
    scale_units_long = 'pixely';
    image_processing
      init_data
        flag copy_frame_condition;
          value = false set CopyFrameCondition;
        end_flag;
        flag pattren_match_condition;
          value = false set PatternMatchCondition;
        end_flag;
        flag get_color_condition;
          value = false set GetColorCondition;
        end_flag;
        flag set_coordinate_sys_condition;
          value = false set SetCoordinateSysCondition;
        end_flag;
        rectangular_region reg_main;
          x = 330.5;
          y = 242.5;
          width = 541;
          height = 445;
          angle = 0;
        end_rectangular_region;
        rectangular_region reg_led_1;
          x = 10;
          y = 18;
          width = 25;
          height = 25;
          angle = 0;
        end_rectangular_region;
        rectangular_region reg_led_2;
          x = 55;
          y = 18;
          width = 25;
          height = 25;
          angle = 0;
        end_rectangular_region;
        rectangular_region reg_led_3;
          x = 100;
          y = 18;
          width = 25;
          height = 25;
          angle = 0;
        end_rectangular_region;
        rectangular_region reg_led_4;
          x = 145;
          y = 18;
          width = 25;
          height = 25;
          angle = 0;
        end_rectangular_region;
        rectangular_region reg_led_5;
          x = 190;
          y = 18;
          width = 25;
          height = 25;
          angle = 0;
        end_rectangular_region;
        rectangular_region reg_led_6;
          x = 235;
          y = 18;
          width = 25;
          height = 25;
          angle = 0;
        end_rectangular_region;
        rectangular_region reg_led_7;
          x = 280;
          y = 18;
          width = 25;
          height = 25;
          angle = 0;
        end_rectangular_region;
        rectangular_region reg_led_8;
          x = 325;
          y = 18;
          width = 25;
          height = 25;
          angle = 0;
        end_rectangular_region;
        number min_matching;
          value = 0;
        end_number;
        number numb_ptm;
          value = 0;
        end_number;
        coordinate_system coordinate_sys;
          x = 0 set CoordinateSys_x;
          y = 0 set CoordinateSys_y;
          angle = 0 set CoordinateSys_a;
        end_coordinate_system;
        frame module_p;
          path = 'Module_P.png';
          mask_path = '';
        end_frame;
        frame module_step_1_error;
          path = 'Module_Step_1_error.png';
          mask_path = '';
        end_frame;
      end_init_data;
      steps
        step pattern_match_monochrome;
          condition = pattren_match_condition;
          input = source, reg_main, module_p, 40, 1, 0.6, 1, , ;
          output = numb_ptm, coordinate_sys, ;
        end_step;
        step set_coordinate_system;
          condition = set_coordinate_sys_condition;
          input = coordinate_sys;
          output = ;
        end_step;
        step copy_frame;
          condition = copy_frame_condition;
          input = module_step_1_error;
          output = source;
        end_step;
        step get_average_color;
          condition = get_color_condition;
          input = source, reg_led_1;
          output = , led_1_hue, , led_1_lum;
        end_step;
        step get_average_color;
          condition = get_color_condition;
          input = source, reg_led_2;
          output = , led_2_hue, , led_2_lum;
        end_step;
        step get_average_color;
          condition = get_color_condition;
          input = source, reg_led_3;
          output = , led_3_hue, , led_3_lum;
        end_step;
        step get_average_color;
          condition = get_color_condition;
          input = source, reg_led_4;
          output = , led_4_hue, , led_4_lum;
        end_step;
        step get_average_color;
          condition = get_color_condition;
          input = source, reg_led_5;
          output = , led_5_hue, , led_5_lum;
        end_step;
        step get_average_color;
          condition = get_color_condition;
          input = source, reg_led_6;
          output = , led_6_hue, , led_6_lum;
        end_step;
        step get_average_color;
          condition = get_color_condition;
          input = source, reg_led_7;
          output = , led_7_hue, , led_7_lum;
        end_step;
        step get_average_color;
          condition = get_color_condition;
          input = source, reg_led_8;
          output = , led_8_hue, , led_8_lum;
        end_step;
      end_steps;
      output_data
        coordinate_system coordinate_sys;
          x = CoordinateSys_x;
          y = CoordinateSys_y;
          angle = CoordinateSys_a;
        end_coordinate_system;
        number numb_ptm;
          value = PatternMatchNumber;
        end_number;
        number led_1_lum;
          value = LedLum[1];
        end_number;
        number led_2_lum;
          value = LedLum[2];
        end_number;
        number led_3_lum;
          value = LedLum[3];
        end_number;
        number led_4_lum;
          value = LedLum[4];
        end_number;
        number led_5_lum;
          value = LedLum[5];
        end_number;
        number led_6_lum;
          value = LedLum[6];
        end_number;
        number led_7_lum;
          value = LedLum[7];
        end_number;
        number led_8_lum;
          value = LedLum[8];
        end_number;
        number led_1_hue;
          value = LedHue[1];
        end_number;
        number led_2_hue;
          value = LedHue[2];
        end_number;
        number led_3_hue;
          value = LedHue[3];
        end_number;
        number led_4_hue;
          value = LedHue[4];
        end_number;
        number led_5_hue;
          value = LedHue[5];
        end_number;
        number led_6_hue;
          value = LedHue[6];
        end_number;
        number led_7_hue;
          value = LedHue[7];
        end_number;
        number led_8_hue;
          value = LedHue[8];
        end_number;
        number min_matching;
        end_number;
        coordinate_system coordinate_sys;
          x = CoordinateSys_x;
          y = CoordinateSys_a;
          angle = CoordinateSys_a;
        end_coordinate_system;
      end_output_data;
    end_image_processing;
    avi
      file_size = 100;
      folder_history = day;
      file_history = hour;
    end_avi;

    procedure Exit( msg : string; err : boolean );
    begin
      dr_LedCheck.UpdateResult( msg, err );
      if err then
        sw_Continue.Enable();
        sw_Continue.Select();
      else
        sw_Start.Enable();
        sw_Start.Select();
        me_Progress.Hide();
      end;
    end_procedure;

    procedure OnImage();
    var
      c : longcard;
      i : longint;
      s : string;
      r : real;
    begin
      (*
      core.DebugOutput( 'ca_ImageFile__OnImage()__Frame', Frame );
      *)
      dr_LedCheck.UpdateFPS( GetFPS());
    
      if Frame = 0 then
        PatternMatchCondition = false;
        if PatternMatchNumber > 0 then
          dr_LedCheck.UpdateResult( sTestRun, false );
          CopyFrameCondition = false;
          SetCoordinateSysCondition = true;
          GetColorCondition = true;
          Frame = Frame + 1;
          send me_Progress;
    
        else
          Exit( 'Module not identified.', true );
    
        end;
    
       elsif Frame = 1 then
         CopyFrameCondition = rand() > trhRandError;
         Frame = Frame + 1;
         send me_Progress;
        
       elsif Frame < lastFrame then
         s = item( bsDO5, ';', Frame - 2 );
         if s <> '' then
           DO = val( s, 2 );
         else
           DO = 0;
         end;
         pa_LedCheck.SetLED( DO );
         Frame = Frame + 1;
    
         c = 0;
         for i = 1 to 8 do
           if LedLum[i] > trhBackgroundLum then
             c = bitset( c, i - 1 );
           end;
         end;
         c = bitxor( c, DO );
         pa_LedCheck.SetLED_Err( c );
    
         if c > 0 then
           s = '';
           for i = 1 to 8 do
             if bitget( c, i - 1 ) = 1 then
               if s <> '' then
                 s = s + ',';
               end;
               s = s + ' DO' + i:s;
             end;
           end;
           Error = true;
           Exit( 'Error : ' + s, true );
         else
           send me_Progress;
         end;
    
       else
         Exit( 'Test Ok.', false );
         pa_LedCheck.SetLED( 0 );
         pa_Logo.Start();
       end;
    end_procedure;

  end_camera;

  panel pa_Logo;
    static
      Counter : cardinal;
      Run : boolean;
    end_static;

    gui
      owner = pa_LedCheck;
      position = 40, 163, 560, 335;
    end_gui;
    dv_file = 'VISIONLAB.JPG';

    procedure OnActivate();
    begin
    
      if Run then
        if Counter = 0 then
          pa_Camera.Hide();
          Show();
          dr_LedCheck.UpdateResult( sReady, false );
          Run = false;
        else
          pause 1;
          Counter = Counter - 1;
          send self;
        end;
      end;
    end_procedure;

    procedure Start();
    begin
      Counter = tmDelayLogoShow;
      Run = true;
      send self;
    end_procedure;

    procedure Stop();
    begin
      Hide();
      Run = false;
    end_procedure;

  end_panel;

  switch sw_Continue;
    gui
      owner = pa_LedCheck;
      position = 406, 563, 100, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Continue';
    false_text = 'Continue';
    colors
      true_paper = dgray;
      false_paper = dgray;
    end_colors;

    procedure OnStartup();
    begin
      Disable();
    end_procedure;

    procedure OnOutput( Output : boolean );
    begin
      Error = false;
      Disable();
      dr_LedCheck.UpdateResult( sTestRun, false );
      CopyFrameCondition = false;
      send me_Progress;
    end_procedure;

  end_switch;

  meter me_Progress;
    gui
      owner = pa_LedCheck;
      position = 550, 49, 80, 8;
    end_gui;
    mode = horizontal_bar;
    colors
      ink = black;
      paper = lgray;
      value = red;
      low_limit = red;
      high_limit = red;
    end_colors;

    procedure OnActivate();
    begin
      SetValue( Frame );
      pause 0.5;
      send ca_ImageFile;
    end_procedure;

  end_meter;

  indicator in_DO8_Err;
    gui
      owner = pa_LedCheck;
      position = 501, 45;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16ron.ico';
    false_icon = 'led16rof.ico';
    colors
      true_paper = 115, 115, 115;
      false_paper = 115, 115, 115;
    end_colors;
  end_indicator;

  indicator in_DO7_Err;
    gui
      owner = pa_LedCheck;
      position = 448, 45;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16ron.ico';
    false_icon = 'led16rof.ico';
    colors
      true_paper = 115, 115, 115;
      false_paper = 115, 115, 115;
    end_colors;
  end_indicator;

  indicator in_DO6_Err;
    gui
      owner = pa_LedCheck;
      position = 395, 45;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16ron.ico';
    false_icon = 'led16rof.ico';
    colors
      true_paper = 115, 115, 115;
      false_paper = 115, 115, 115;
    end_colors;
  end_indicator;

  indicator in_DO5_Err;
    gui
      owner = pa_LedCheck;
      position = 342, 45;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16ron.ico';
    false_icon = 'led16rof.ico';
    colors
      true_paper = 115, 115, 115;
      false_paper = 115, 115, 115;
    end_colors;
  end_indicator;

  indicator in_DO4_Err;
    gui
      owner = pa_LedCheck;
      position = 289, 45;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16ron.ico';
    false_icon = 'led16rof.ico';
    colors
      true_paper = 115, 115, 115;
      false_paper = 115, 115, 115;
    end_colors;
  end_indicator;

  indicator in_DO3_Err;
    gui
      owner = pa_LedCheck;
      position = 236, 45;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16ron.ico';
    false_icon = 'led16rof.ico';
    colors
      true_paper = 115, 115, 115;
      false_paper = 115, 115, 115;
    end_colors;
  end_indicator;

  indicator in_DO2_Err;
    gui
      owner = pa_LedCheck;
      position = 183, 45;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16ron.ico';
    false_icon = 'led16rof.ico';
    colors
      true_paper = 115, 115, 115;
      false_paper = 115, 115, 115;
    end_colors;
  end_indicator;

  indicator in_DO1_Err;
    gui
      owner = pa_LedCheck;
      position = 130, 45;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16ron.ico';
    false_icon = 'led16rof.ico';
    colors
      true_paper = 115, 115, 115;
      false_paper = 115, 115, 115;
    end_colors;
  end_indicator;

  indicator in_DO8;
    gui
      owner = pa_LedCheck;
      position = 501, 23;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16yon.ico';
    false_icon = 'led16yof.ico';
    colors
      true_paper = 147, 147, 147;
      false_paper = 147, 147, 147;
    end_colors;
  end_indicator;

  indicator in_DO7;
    gui
      owner = pa_LedCheck;
      position = 448, 23;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16yon.ico';
    false_icon = 'led16yof.ico';
    colors
      true_paper = 147, 147, 147;
      false_paper = 147, 147, 147;
    end_colors;
  end_indicator;

  indicator in_DO6;
    gui
      owner = pa_LedCheck;
      position = 395, 23;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16yon.ico';
    false_icon = 'led16yof.ico';
    colors
      true_paper = 147, 147, 147;
      false_paper = 147, 147, 147;
    end_colors;
  end_indicator;

  indicator in_DO5;
    gui
      owner = pa_LedCheck;
      position = 342, 23;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16yon.ico';
    false_icon = 'led16yof.ico';
    colors
      true_paper = 147, 147, 147;
      false_paper = 147, 147, 147;
    end_colors;
  end_indicator;

  indicator in_DO4;
    gui
      owner = pa_LedCheck;
      position = 289, 23;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16yon.ico';
    false_icon = 'led16yof.ico';
    colors
      true_paper = 147, 147, 147;
      false_paper = 147, 147, 147;
    end_colors;
  end_indicator;

  indicator in_DO3;
    gui
      owner = pa_LedCheck;
      position = 236, 23;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16yon.ico';
    false_icon = 'led16yof.ico';
    colors
      true_paper = 147, 147, 147;
      false_paper = 147, 147, 147;
    end_colors;
  end_indicator;

  indicator in_DO2;
    gui
      owner = pa_LedCheck;
      position = 183, 23;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16yon.ico';
    false_icon = 'led16yof.ico';
    colors
      true_paper = 147, 147, 147;
      false_paper = 147, 147, 147;
    end_colors;
  end_indicator;

  indicator in_DO1;
    gui
      owner = pa_LedCheck;
      position = 130, 23;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    true_icon = 'led16yon.ico';
    false_icon = 'led16yof.ico';
    colors
      true_paper = 147, 147, 147;
      false_paper = 147, 147, 147;
    end_colors;
  end_indicator;

  switch sw_Start;
    static
      Counter : cardinal;
    end_static;

    activity
      period = 1;
    end_activity;
    gui
      owner = pa_LedCheck;
      position = 516, 563, 100, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    font = 'Tahoma (Central European)', 8, bold;
    true_text = 'Start';
    false_text = 'Start';
    colors
      true_paper = dgray;
      false_paper = dgray;
    end_colors;

    procedure OnActivate();
    begin
      Counter = Counter + 1;
      if Counter > tmTestAutoRepeat then
        if Error then
          sw_Continue.OnOutput( true );
          Counter = 0;
        else
          OnOutput( true );
        end;
      end;
    end_procedure;

    procedure OnOutput( Output : boolean );
    begin
      Counter = 0;
      Disable();
      pa_Camera.Show();
      pa_Logo.Stop();
      dr_LedCheck.UpdateResult( sPrepare, false );
      me_Progress.SetRange( 0, lastFrame );
      me_Progress.SetValue( 0 );
      me_Progress.Show();
      pa_LedCheck.SetLED( 0 );
      pa_LedCheck.SetLED_Err( 0 );
      CopyFrameCondition = false;
      PatternMatchCondition = true;
      SetCoordinateSysCondition = false;
      GetColorCondition = false;
      Frame = 0;
      send ca_ImageFile;
    end_procedure;

  end_switch;

  draw dr_LedCheck;
    static
      H_tx_CamStat : longcard;
      H_tx_FPS : longcard;
      H_tx_Result : longcard;
    end_static;

    gui
      owner = pa_LedCheck;
      position = 0, 0, 640, 600;
    end_gui;
    color = 223, 223, 223;
    drawing
      ink 63, 63, 63;
      fill
        direction down;
        color lgray;
        color 95, 95, 95;
      end;
      box_border 0, 0, 640, 70;
      fill
        direction down;
        color 95, 95, 95;
        color lgray;
      end;
      box_border 0, 550, 640, 50;
      line 100, 1, 100, 69;
      line 540, 1, 540, 69;
      text tx_CamStat 22, 23, 
        'Image file' , 
        font = 'Tahoma (Central European)', 10, bold; 
      text tx_FPS 573, 23, 
        ' 0.00' , 
        font = 'Tahoma (Central European)', 10, bold; 
      text tx_Result 15, 570, 
        '' , 
        font = 'Tahoma (Central European)', 10, bold; 
      textcolor white;
      text tx_ 24, 5, 
        'DataCam' , 
        font = 'Tahoma (Central European)', 8, bold; 
      text tx_ 579, 5, 
        'FPS' , 
        font = 'Tahoma (Central European)', 8, bold; 
      text tx_ 127, 5, 
        'DO1' , 
        font = 'Tahoma (Central European)', 8, normal; 
      text tx_ 180, 5, 
        'DO2' , 
        font = 'Tahoma (Central European)', 8, normal; 
      text tx_ 233, 5, 
        'DO3' , 
        font = 'Tahoma (Central European)', 8, normal; 
      text tx_ 286, 5, 
        'DO4' , 
        font = 'Tahoma (Central European)', 8, normal; 
      text tx_ 339, 5, 
        'DO5' , 
        font = 'Tahoma (Central European)', 8, normal; 
      text tx_ 392, 5, 
        'DO6' , 
        font = 'Tahoma (Central European)', 8, normal; 
      text tx_ 445, 5, 
        'DO7' , 
        font = 'Tahoma (Central European)', 8, normal; 
      text tx_ 498, 5, 
        'DO8' , 
        font = 'Tahoma (Central European)', 8, normal; 
      fill
        direction down;
        color 95, 95, 95;
        color 63, 63, 63;
        color 95, 95, 95;
      end;
      box_border 0, 69, 640, 482;
      ink red;
      fill
        direction down;
        color 95, 95, 95;
        color lgray;
        color 95, 95, 95;
      end;
      box_border 20, 140, 600, 380;
      textcolor black;
      text tx_Result 23, 83, 
        'Machine vision for Control Web' , 
        font = 'Tahoma (Central European)', 28, bolditalic; 
      textcolor 192, 0, 0;
      text tx_Result 20, 80, 
        'Machine vision for Control Web' , 
        font = 'Tahoma (Central European)', 28, bolditalic; 
    end;

    procedure OnStartup();
    begin
      ObjectNameToHandle( 'tx_CamStat', H_tx_CamStat );
      ObjectNameToHandle( 'tx_FPS', H_tx_FPS );
      ObjectNameToHandle( 'tx_Result', H_tx_Result );
    end_procedure;

    procedure UpdateFPS( fps : real );
    begin
      TextSetText( H_tx_FPS, strf( fps, '##.##' ));
      PaintMarked();
    end_procedure;

    procedure UpdateResult( s : string; err : boolean );
    begin
      if err then
        ObjectSetTextColor( H_tx_Result, 255 ); 
      else
        ObjectSetTextColor( H_tx_Result, 0 ); 
      end;
      TextSetText( H_tx_Result, s );
      PaintMarked();
    end_procedure;

  end_draw;

  program startup;

    procedure OnActivate();
    begin
       sw_Start.Select();
       dr_LedCheck.UpdateResult( sReady, false );
    end_procedure;

  end_program;

  switch sw_Test;
    gui
      position = 298, 561, 100, 25;
      window
        disable = zoom, maximize;
      end_window;
    end_gui;
    mode = text_button;
    true_text = 'Test';
    false_text = 'Test';

    procedure OnOutput( Output : boolean );
    var
      i : longcard;
      c : longcard;
      r : real;
    begin
      c = 0;
      for i = 1 to 10000 do
        r = rand();
        if r > 0.9 then
          c = c + 1;
        end;
      end;
      core.DebugOutput( '****', c );
    
      c = 0;
      for i = 1 to 10000 do
        if rand() > 0.9 then
          c = c + 1;
        end;
      end;
      core.DebugOutput( '****', c );
    end_procedure;

  end_switch;

end_instrument;

